/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.btf;

import crystalpalace.btf.Code;
import crystalpalace.btf.CodeUtils;
import crystalpalace.btf.FixBSSReferencesX64;
import crystalpalace.btf.FixBSSReferencesX86;
import crystalpalace.btf.FixX86References;
import crystalpalace.btf.FunctionDisco;
import crystalpalace.btf.GoFirst;
import crystalpalace.btf.LinkTimeOptimizer;
import crystalpalace.btf.Mutator;
import crystalpalace.btf.Rebuilder;
import crystalpalace.btf.ResolveAPI;
import crystalpalace.coff.COFFObject;
import crystalpalace.coff.COFFParser;
import crystalpalace.export.DFR;
import crystalpalace.merge.COFFMerge;
import crystalpalace.util.CrystalUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Modify {
    protected COFFObject object;

    public Modify(COFFObject object) {
        this.object = object;
    }

    public COFFObject fixX86(String retaddr) {
        if (retaddr == null) {
            return this.object;
        }
        Code code = Code.Init(this.object).analyze();
        Map funcs = code.getCodeByFunction();
        return new Rebuilder(code, funcs).rebuild(new FixX86References(code, retaddr));
    }

    public COFFObject fixBSS(String getbss) {
        if (getbss == null) {
            return this.object;
        }
        Code code = Code.Init(this.object).analyze();
        Map funcs = code.getCodeByFunction();
        if ("x64".equals(this.object.getMachine())) {
            return new Rebuilder(code, funcs).rebuild(new FixBSSReferencesX64(code, getbss));
        }
        return new Rebuilder(code, funcs).rebuild(new FixBSSReferencesX86(code, getbss));
    }

    public COFFObject resolve(DFR resolvers) {
        if (!resolvers.hasResolvers()) {
            return this.object;
        }
        Code code = Code.Init(this.object).analyze();
        Map funcs = code.getCodeByFunction();
        return new Rebuilder(code, funcs).rebuild(new ResolveAPI(code, resolvers));
    }

    public COFFObject modify(boolean preserveFirst, Set options) {
        if (options.size() == 0) {
            return this.object;
        }
        Code code = Code.Init(this.object).analyze();
        Map funcs = code.getCodeByFunction();
        if (options.contains("+gofirst")) {
            funcs = new GoFirst(code).apply(funcs);
        }
        if (options.contains("+optimize")) {
            funcs = new LinkTimeOptimizer(code).apply(funcs);
        }
        if (options.contains("+disco")) {
            funcs = new FunctionDisco(code).apply(preserveFirst, funcs);
        }
        if (options.contains("+mutate")) {
            return new Rebuilder(code, funcs).rebuild(new Mutator(code));
        }
        return new Rebuilder(code, funcs).rebuild();
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            CrystalUtils.print_error("./disassemble <+mutate,+optimize,+disco,+gofirst> [/path/to/file.o]");
            return;
        }
        COFFObject obj = null;
        String opts = "";
        try {
            if (args.length == 1) {
                obj = new COFFParser().parse(CrystalUtils.readFromFile(args[0])).getObject();
            } else if (args.length == 2) {
                opts = args[0];
                obj = new COFFParser().parse(CrystalUtils.readFromFile(args[1])).getObject();
            }
            COFFMerge merge = new COFFMerge();
            merge.merge(obj);
            merge.finish();
            obj = merge.getObject();
            obj = new Modify(obj).modify(false, "".equals(opts) ? new HashSet() : CrystalUtils.toSet(opts));
            CodeUtils.print(Code.Init(obj).analyze());
        }
        catch (Exception ex) {
            CrystalUtils.handleException(ex);
        }
    }
}

