/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.btf;

import com.github.icedland.iced.x86.Instruction;
import crystalpalace.btf.Code;
import crystalpalace.coff.COFFObject;
import crystalpalace.coff.Relocation;
import crystalpalace.coff.Symbol;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LinkTimeOptimizer {
    protected COFFObject object = null;
    protected Set touched = new HashSet();
    protected Map funcs = null;
    protected Code code = null;

    public LinkTimeOptimizer(Code code) {
        this.code = code;
        this.object = code.getObject();
    }

    protected void walk_x64(String function) {
        HashSet<String> x64insts = new HashSet<String>();
        x64insts.add("LEA r64, m");
        x64insts.add("MOV r64, r/m64");
        x64insts.add("CALL r/m64");
        this.touched.add(function);
        for (Instruction inst : (List)this.funcs.get(function)) {
            String symb;
            Symbol temp;
            Relocation r;
            Symbol temp2;
            if (inst.isCallNear()) {
                temp2 = this.code.getLabel(inst.getMemoryDisplacement32());
                if (temp2 != null && !this.touched.contains(temp2.getName())) {
                    this.walk_x64(temp2.getName());
                }
            } else if (inst.isIPRelativeMemoryOperand() && x64insts.contains(inst.getOpCode().toInstructionString()) && (temp2 = this.code.getLabel(inst.getMemoryDisplacement32())) != null && !this.touched.contains(temp2.getName())) {
                this.walk_x64(temp2.getName());
            }
            if ((r = this.code.getRelocation(inst)) == null || !r.getSymbolName().startsWith(".refptr.") || (temp = this.object.getSymbol(symb = r.getSymbolName().substring(8))) == null || !".text".equals(temp.getSection().getName()) || this.touched.contains(temp.getName())) continue;
            this.walk_x64(temp.getName());
        }
    }

    protected void walk_x86(String function) {
        this.touched.add(function);
        for (Instruction inst : (List)this.funcs.get(function)) {
            Symbol temp;
            Relocation r;
            Symbol temp2;
            if (inst.isCallNear() && (temp2 = this.code.getLabel(inst.getMemoryDisplacement32())) != null && !this.touched.contains(temp2.getName())) {
                this.walk_x86(temp2.getName());
            }
            if ((r = this.code.getRelocation(inst)) != null && ".text".equals(r.getSymbolName())) {
                temp = this.code.getLabel(r.getOffsetAsLong());
                if (temp == null || this.touched.contains(temp.getName())) continue;
                this.walk_x86(temp.getName());
                continue;
            }
            if (r == null || (temp = this.object.getSymbol(r.getSymbolName())) == null || temp.getSection() == null || !".text".equals(temp.getSection().getName()) || this.touched.contains(temp.getName())) continue;
            this.walk_x86(temp.getName());
        }
    }

    public Map apply(Map _funcs) {
        this.funcs = _funcs;
        if ("x64".equals(this.object.getMachine())) {
            if (!this.funcs.containsKey("go")) {
                throw new RuntimeException("+optimize requires go() function as entrypoint");
            }
            this.walk_x64("go");
        } else {
            if (!this.funcs.containsKey("_go")) {
                throw new RuntimeException("+optimize requires _go() function as entrypoint");
            }
            this.walk_x86("_go");
        }
        HashSet<String> removeme = new HashSet<String>();
        Iterator i = this.funcs.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (!this.object.getSymbol(entry.getKey().toString()).isFunction() || this.touched.contains(entry.getKey().toString())) continue;
            i.remove();
            removeme.add(entry.getKey().toString());
        }
        this.object.removeSymbols(removeme);
        return this.funcs;
    }
}

