/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.btf;

import crystalpalace.btf.Code;
import crystalpalace.coff.COFFObject;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public class FunctionDisco {
    protected COFFObject object = null;
    protected Map funcs = null;
    protected Code code = null;

    public FunctionDisco(Code code) {
        this.code = code;
        this.object = code.getObject();
    }

    public int countFunctions(Map funcs) {
        int count = 0;
        for (String func : funcs.keySet()) {
            if (!this.code.isFunction(func)) continue;
            ++count;
        }
        return count;
    }

    public Map apply(boolean preserveFirst, Map funcs) {
        String func;
        if (this.countFunctions(funcs) <= 1) {
            return funcs;
        }
        LinkedHashMap results = new LinkedHashMap();
        if (preserveFirst) {
            String first = (String)funcs.keySet().iterator().next();
            results.put(first, funcs.get(first));
            funcs.remove(first);
        }
        LinkedList labels = new LinkedList(funcs.keySet());
        Collections.shuffle(labels);
        while (!preserveFirst && !this.code.isFunction(func = (String)labels.peekFirst())) {
            labels.add(labels.removeFirst());
        }
        for (String name : labels) {
            results.put(name, funcs.get(name));
        }
        return results;
    }
}

