/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.btf;

import com.github.icedland.iced.x86.ICRegister;
import com.github.icedland.iced.x86.ICRegisters;
import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.asm.AsmMemoryOperand;
import com.github.icedland.iced.x86.asm.AsmRegister32;
import com.github.icedland.iced.x86.asm.AsmRegisters;
import com.github.icedland.iced.x86.asm.CodeAssembler;
import crystalpalace.btf.BaseModify;
import crystalpalace.btf.Code;
import crystalpalace.btf.CodeInfo;
import crystalpalace.btf.CodeUtils;
import crystalpalace.btf.RebuildStep;
import crystalpalace.export.ParseImport;
import java.util.List;

public class FixX86References
extends BaseModify {
    protected String retaddr = null;

    @Override
    public void setupVerbs() {
        this.verbs.add(new MovR32Imm32());
        this.verbs.add(new MovMem32Imm32());
        this.verbs.add(new MovR32Moffs32());
    }

    @Override
    public boolean shouldModify(RebuildStep step, Instruction next) {
        if (this.x64) {
            return false;
        }
        if (!step.hasRelocation()) {
            return false;
        }
        ParseImport resolveme = new ParseImport(step.getRelocation().getSymbolName());
        if (resolveme.isValid()) {
            return false;
        }
        if (".bss".equals(step.getRelocation().getSymbolName())) {
            return false;
        }
        String istr = next.getOpCode().toInstructionString();
        return !"CALL rel32".equals(istr);
    }

    @Override
    public void noMatch(CodeAssembler program, RebuildStep step, Instruction next) {
        System.out.println(next.getOpCode().toInstructionString());
        CodeUtils.printInst(this.code, next);
        CodeInfo.Dump(next, null);
        throw new RuntimeException("Can't transform '" + step.getInstructionString() + "' to handle " + step.getRelocation() + ". Change your compiler optimization settings or turn off optimizations for this function.");
    }

    public FixX86References(Code code, String retaddr) {
        super(code);
        this.retaddr = retaddr;
    }

    private class MovR32Imm32
    implements BaseModify.ModifyVerb {
        private MovR32Imm32() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOV r32, imm32".equals(istr);
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            AsmRegister32 dst = new AsmRegister32(new ICRegister(next.getOp0Register()));
            AsmRegister32 eax = new AsmRegister32(ICRegisters.eax);
            List saved = FixX86References.this.pushad(program);
            AsmRegister32 tmp = FixX86References.this.getReg32(saved, dst);
            if (dst.equals(eax)) {
                program.call(step.getLabel(FixX86References.this.retaddr));
                step.createLabel(program);
                next.setOp0Register(tmp.getRegister());
                program.addInstruction(next);
                program.add(tmp, step.getInstructionLength());
                program.add(eax, tmp);
            } else {
                program.push(eax);
                program.call(step.getLabel(FixX86References.this.retaddr));
                step.createLabel(program);
                program.addInstruction(next);
                program.add(dst, step.getInstructionLength());
                program.add(dst, eax);
                program.pop(eax);
            }
            FixX86References.this.popad(program, saved);
        }
    }

    private class MovR32Moffs32
    implements BaseModify.ModifyVerb {
        private MovR32Moffs32() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOV EAX, moffs32".equals(istr);
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            AsmRegister32 eax = new AsmRegister32(ICRegisters.eax);
            List saved = FixX86References.this.pushad(program);
            AsmRegister32 tmp = FixX86References.this.getReg32(saved, null);
            program.call(step.getLabel(FixX86References.this.retaddr));
            step.createLabel(program);
            program.mov(tmp, next.getImmediate32());
            program.add(tmp, 5);
            program.add(tmp, eax);
            program.mov(eax, AsmRegisters.mem_ptr(tmp));
            FixX86References.this.popad(program, saved);
        }
    }

    private class MovMem32Imm32
    implements BaseModify.ModifyVerb {
        private MovMem32Imm32() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOV r/m32, imm32".equals(istr) && (next.getMemoryBase() == 42 || next.getMemoryBase() == 41);
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            AsmMemoryOperand dst = FixX86References.this.getMemOperand(next);
            AsmRegister32 eax = new AsmRegister32(ICRegisters.eax);
            List saved = FixX86References.this.pushad(program);
            AsmRegister32 tmp = FixX86References.this.getReg32(saved, null);
            program.push(eax);
            program.call(step.getLabel(FixX86References.this.retaddr));
            step.createLabel(program);
            step.setRelocOffset(1);
            program.mov(tmp, 0);
            program.add(tmp, 5);
            program.add(tmp, eax);
            if (next.getMemoryBase() == 41) {
                dst = dst.add(12L);
            }
            program.mov(dst, tmp);
            program.pop(eax);
            FixX86References.this.popad(program, saved);
        }
    }
}

