/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.btf;

import com.github.icedland.iced.x86.ICRegister;
import com.github.icedland.iced.x86.ICRegisters;
import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.asm.AsmMemoryOperand;
import com.github.icedland.iced.x86.asm.AsmRegister32;
import com.github.icedland.iced.x86.asm.AsmRegisters;
import com.github.icedland.iced.x86.asm.CodeAssembler;
import crystalpalace.btf.BaseModify;
import crystalpalace.btf.Code;
import crystalpalace.btf.CodeInfo;
import crystalpalace.btf.CodeUtils;
import crystalpalace.btf.RebuildStep;
import crystalpalace.btf.RegValue;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FixBSSReferencesX86
extends BaseModify {
    protected String getbss = null;
    protected int bsssize = 0;

    @Override
    public void setupVerbs() {
        this.verbs.add(new LoadAddress());
        this.verbs.add(new LoadAddressReg());
        this.verbs.add(new LoadEAX());
        this.verbs.add(new Load32_8());
        this.verbs.add(new Load32_16());
        this.verbs.add(new Load32_32());
        this.verbs.add(new Store32_32());
        this.verbs.add(new Store32_16());
        this.verbs.add(new Store32_8());
        this.verbs.add(new StoreConstant());
    }

    @Override
    public boolean shouldModify(RebuildStep step, Instruction next) {
        if (!step.hasRelocation()) {
            return false;
        }
        return ".bss".equals(step.getRelocation().getSymbolName());
    }

    @Override
    public void noMatch(CodeAssembler program, RebuildStep step, Instruction next) {
        System.out.println(next.getOpCode().toInstructionString());
        CodeUtils.printInst(this.code, next);
        CodeInfo.Dump(next, null);
        throw new RuntimeException("Can't transform '" + step.getInstructionString() + "' to handle " + step.getRelocation() + ". Change your compiler optimization settings or turn off optimizations for this function.");
    }

    public FixBSSReferencesX86(Code code, String getbss) {
        super(code);
        this.getbss = getbss;
    }

    public void callGetBSS(CodeAssembler program, RebuildStep step) {
        AsmRegister32 eax = new AsmRegister32(ICRegisters.eax);
        AsmRegister32 esp = new AsmRegister32(ICRegisters.esp);
        int bsslen = this.object.getSection(".bss").getRawData().length;
        List saved = this.pushad(program);
        program.push(bsslen);
        program.call(step.getLabel(this.getbss));
        program.add(esp, 4);
        this.popad(program, saved);
        program.add(eax, step.getRelocation().getOffsetAsLong());
    }

    private class Store32_8
    extends StoreValue32 {
        private Store32_8() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            if ("MOV moffs8, AL".equals(istr)) {
                return true;
            }
            return "MOV r/m8, r8".equals(istr) && next.getMemoryBase() == 0;
        }

        @Override
        public AsmRegister32 getTmpReg(AsmRegister32 _rax) {
            switch (FixBSSReferencesX86.this.nextInt(3)) {
                case 0: {
                    return new AsmRegister32(ICRegisters.ebx);
                }
                case 1: {
                    return new AsmRegister32(ICRegisters.ecx);
                }
                case 2: {
                    return new AsmRegister32(ICRegisters.edx);
                }
            }
            throw new RuntimeException("Bad tmp reg");
        }

        @Override
        public boolean is(RegValue rax, RegValue src) {
            return rax.getReg8().equals(src.getReg8());
        }

        @Override
        public void copyTemp(CodeAssembler program, RegValue tmp, RegValue src) {
            program.mov(tmp.getReg8(), src.getReg8());
        }

        @Override
        public void storeValue(CodeAssembler program, RegValue dst, RegValue src) {
            program.mov(AsmRegisters.byte_ptr(dst.getReg32(), 0L), src.getReg8());
        }
    }

    private class Store32_16
    extends StoreValue32 {
        private Store32_16() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            if ("MOV moffs16, AX".equals(istr)) {
                return true;
            }
            return "MOV r/m16, r16".equals(istr) && next.getMemoryBase() == 0;
        }

        @Override
        public boolean is(RegValue rax, RegValue src) {
            return rax.getReg16().equals(src.getReg16());
        }

        @Override
        public void copyTemp(CodeAssembler program, RegValue tmp, RegValue src) {
            program.mov(tmp.getReg16(), src.getReg16());
        }

        @Override
        public void storeValue(CodeAssembler program, RegValue dst, RegValue src) {
            program.mov(AsmRegisters.word_ptr(dst.getReg32(), 0L), src.getReg16());
        }
    }

    private class Store32_32
    extends StoreValue32 {
        private Store32_32() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            if ("MOV moffs32, EAX".equals(istr)) {
                return true;
            }
            return "MOV r/m32, r32".equals(istr) && next.getMemoryBase() == 0;
        }

        @Override
        public boolean is(RegValue rax, RegValue src) {
            return rax.getReg32().equals(src.getReg32());
        }

        @Override
        public void copyTemp(CodeAssembler program, RegValue tmp, RegValue src) {
            program.mov(tmp.getReg32(), src.getReg32());
        }

        @Override
        public void storeValue(CodeAssembler program, RegValue dst, RegValue src) {
            program.mov(AsmRegisters.mem_ptr(dst.getReg32(), 0L), src.getReg32());
        }
    }

    private abstract class StoreValue32
    implements BaseModify.ModifyVerb {
        private StoreValue32() {
        }

        public abstract boolean is(RegValue var1, RegValue var2);

        public abstract void copyTemp(CodeAssembler var1, RegValue var2, RegValue var3);

        public abstract void storeValue(CodeAssembler var1, RegValue var2, RegValue var3);

        public AsmRegister32 getTmpReg(AsmRegister32 _rax) {
            return FixBSSReferencesX86.this.getRandReg32(_rax);
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            AsmRegister32 _rax = new AsmRegister32(ICRegisters.eax);
            AsmRegister32 _tmp = this.getTmpReg(_rax);
            RegValue rax = RegValue.toRegValue(_rax);
            RegValue tmp = RegValue.toRegValue(_tmp);
            RegValue src = RegValue.toRegValue(next, 1);
            if (this.is(rax, src)) {
                program.push(_tmp);
                this.copyTemp(program, tmp, src);
                FixBSSReferencesX86.this.callGetBSS(program, step);
                this.storeValue(program, rax, tmp);
                program.pop(_tmp);
            } else {
                program.push(_rax);
                FixBSSReferencesX86.this.callGetBSS(program, step);
                this.storeValue(program, rax, src);
                program.pop(_rax);
            }
            step.resolve();
        }
    }

    private class LoadAddressReg
    implements BaseModify.ModifyVerb {
        private LoadAddressReg() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOV r32, imm32".equals(istr);
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            AsmRegister32 eax = new AsmRegister32(ICRegisters.eax);
            AsmRegister32 dst = new AsmRegister32(new ICRegister(next.getOp0Register()));
            if (dst.equals(eax)) {
                FixBSSReferencesX86.this.callGetBSS(program, step);
            } else {
                program.push(eax);
                FixBSSReferencesX86.this.callGetBSS(program, step);
                program.mov(dst, eax);
                program.pop(eax);
            }
            step.resolve();
        }
    }

    private class LoadAddress
    implements BaseModify.ModifyVerb {
        private LoadAddress() {
        }

        public boolean isDesiredReg(Instruction next) {
            return next.getMemoryBase() == 42 || next.getMemoryBase() == 41;
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOV r/m32, imm32".equals(istr) && this.isDesiredReg(next);
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            AsmRegister32 eax = new AsmRegister32(ICRegisters.eax);
            AsmMemoryOperand dst = FixBSSReferencesX86.this.getMemOperand(next);
            program.push(eax);
            FixBSSReferencesX86.this.callGetBSS(program, step);
            if (next.getMemoryBase() == 41) {
                dst = dst.add(4L);
            }
            program.mov(dst, eax);
            program.pop(eax);
            step.resolve();
        }
    }

    private class LoadEAX
    implements BaseModify.ModifyVerb {
        private LoadEAX() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOV EAX, moffs32".equals(istr);
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            AsmRegister32 eax = new AsmRegister32(ICRegisters.eax);
            FixBSSReferencesX86.this.callGetBSS(program, step);
            program.mov(eax, AsmRegisters.mem_ptr(eax, 0L));
            step.resolve();
        }
    }

    private class Load32_32
    extends LoadValue32 {
        private Load32_32() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOV r32, r/m32".equals(istr) && next.getMemoryBase() == 0;
        }

        @Override
        protected void load(CodeAssembler program, Instruction next, AsmRegister32 dst, AsmRegister32 src) {
            program.mov(dst, AsmRegisters.mem_ptr(src, 0L));
        }
    }

    private class Load32_16
    extends LoadValue32 {
        private Load32_16() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOVZX r32, r/m16".equals(istr) && next.getMemoryBase() == 0;
        }

        @Override
        protected void load(CodeAssembler program, Instruction next, AsmRegister32 dst, AsmRegister32 src) {
            program.movzx(dst, AsmRegisters.word_ptr(src, 0L));
        }
    }

    private class Load32_8
    extends LoadValue32 {
        private Load32_8() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOVZX r32, r/m8".equals(istr) && next.getMemoryBase() == 0;
        }

        @Override
        protected void load(CodeAssembler program, Instruction next, AsmRegister32 dst, AsmRegister32 src) {
            program.movzx(dst, AsmRegisters.byte_ptr(src, 0L));
        }
    }

    private abstract class LoadValue32
    implements BaseModify.ModifyVerb {
        private LoadValue32() {
        }

        protected abstract void load(CodeAssembler var1, Instruction var2, AsmRegister32 var3, AsmRegister32 var4);

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            AsmRegister32 eax;
            AsmRegister32 dst = new AsmRegister32(new ICRegister(next.getOp0Register()));
            if (dst.equals(eax = new AsmRegister32(ICRegisters.eax))) {
                FixBSSReferencesX86.this.callGetBSS(program, step);
                this.load(program, next, eax, eax);
            } else {
                program.push(eax);
                FixBSSReferencesX86.this.callGetBSS(program, step);
                this.load(program, next, dst, eax);
                program.pop(eax);
            }
            step.resolve();
        }
    }

    private class StoreConstant
    implements BaseModify.ModifyVerb {
        protected Set valid = new HashSet();

        public StoreConstant() {
            this.valid.add("MOV r/m8, imm8");
            this.valid.add("MOV r/m16, imm16");
            this.valid.add("MOV r/m32, imm32");
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return this.valid.contains(istr) && next.getMemoryBase() == 0;
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            int val = next.getImmediate32();
            String istr = next.getOpCode().toInstructionString();
            AsmRegister32 eax = new AsmRegister32(ICRegisters.eax);
            program.push(eax);
            FixBSSReferencesX86.this.callGetBSS(program, step);
            if ("MOV r/m8, imm8".equals(istr)) {
                program.mov(AsmRegisters.byte_ptr(eax, 0L), val);
            } else if ("MOV r/m16, imm16".equals(istr)) {
                program.mov(AsmRegisters.word_ptr(eax, 0L), val);
            } else if ("MOV r/m32, imm32".equals(istr)) {
                program.mov(AsmRegisters.dword_ptr(eax, 0L), val);
            } else {
                throw new RuntimeException("Invalid istr " + istr + " in x86 StoreConstant");
            }
            program.pop(eax);
            step.resolve();
        }
    }
}

