/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.btf;

import com.github.icedland.iced.x86.ConstantOffsets;
import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.dec.ByteArrayCodeReader;
import com.github.icedland.iced.x86.dec.Decoder;
import com.github.icedland.iced.x86.fmt.SymbolResult;
import crystalpalace.btf.Code;
import crystalpalace.coff.COFFObject;
import crystalpalace.coff.Relocation;
import crystalpalace.coff.Symbol;
import java.util.LinkedList;
import java.util.List;

public class CodeX86
extends Code {
    public CodeX86(COFFObject o) {
        super(o);
    }

    @Override
    public List disassemble() {
        ByteArrayCodeReader codeReader = new ByteArrayCodeReader(this.code);
        Decoder decoder = new Decoder(this.object.getBits(), codeReader);
        decoder.setIP(this.startip);
        long endRip = decoder.getIP() + (long)this.code.length;
        LinkedList<Instruction> instructions = new LinkedList<Instruction>();
        while (decoder.getIP() < endRip) {
            Instruction instr = decoder.decode();
            ConstantOffsets _offsets = decoder.getConstantOffsets(instr);
            if (_offsets.hasDisplacement() || _offsets.hasImmediate() || _offsets.hasImmediate2()) {
                this.offsets.put(instr, _offsets);
            }
            instructions.add(instr);
        }
        return instructions;
    }

    @Override
    public Relocation getRelocation(Instruction instr) {
        if (this.hasOffsets(instr)) {
            return (Relocation)this.relocs.get(this.getRelocationAddress(instr));
        }
        return null;
    }

    @Override
    public SymbolResult relocationToSymbol(Relocation reloc, int operand, long address) {
        if (operand == 0) {
            Symbol temp;
            if (".text".equals(reloc.getSymbolName()) && (temp = this.getLabel(address)) != null) {
                return new SymbolResult(address, temp.getName());
            }
            return new SymbolResult(0L, reloc.getSymbolName());
        }
        return null;
    }

    private long getRelocationAddress(Instruction instr) {
        long cand;
        ConstantOffsets offsets = this.getOffsets(instr);
        if (offsets.hasDisplacement() && this.relocs.containsKey(cand = instr.getIP() + (long)offsets.displacementOffset)) {
            return cand;
        }
        if (offsets.hasImmediate() && this.relocs.containsKey(cand = instr.getIP() + (long)offsets.immediateOffset)) {
            return cand;
        }
        if (offsets.hasImmediate2() && this.relocs.containsKey(cand = instr.getIP() + (long)offsets.immediateOffset2)) {
            return cand;
        }
        return instr.getIP();
    }
}

