/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.btf;

import com.github.icedland.iced.x86.FpuStackIncrementInfo;
import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.MemorySize;
import com.github.icedland.iced.x86.fmt.StringOutput;
import com.github.icedland.iced.x86.fmt.SymbolResolver;
import com.github.icedland.iced.x86.fmt.SymbolResult;
import com.github.icedland.iced.x86.fmt.gas.GasFormatter;
import com.github.icedland.iced.x86.info.InstructionInfo;
import com.github.icedland.iced.x86.info.InstructionInfoFactory;
import com.github.icedland.iced.x86.info.OpCodeInfo;
import crystalpalace.btf.Code;
import crystalpalace.coff.Relocation;
import crystalpalace.util.CrystalUtils;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;

public class CodeUtils {
    private static final int HEXBYTES_COLUMN_BYTE_LENGTH = 10;

    public static void details(Code code, String msg, Instruction instr) {
        CrystalUtils.print_stat(msg + ":");
        System.out.println(instr.getOpCode().toInstructionString());
        CodeUtils.printInst(code, instr);
        CodeUtils.dump(instr);
        System.out.println("---");
    }

    public static String toString(Instruction instr) {
        return String.format("%016X %s", instr.getIP(), instr.getOpCode().toInstructionString());
    }

    public static void p(Instruction instr) {
        CrystalUtils.print_warn(String.format("%016X %s", instr.getIP(), instr.getOpCode().toInstructionString()));
    }

    public static void dump(Instruction instr) {
        InstructionInfoFactory instrInfoFactory = new InstructionInfoFactory();
        System.out.println(String.format("%016X %s", instr.getIP(), instr));
        OpCodeInfo opCode = instr.getOpCode();
        InstructionInfo info = instrInfoFactory.getInfo(instr);
        FpuStackIncrementInfo fpuInfo = instr.getFpuStackIncrementInfo();
        System.out.println(String.format("    OpCode: %s", opCode.toOpCodeString()));
        System.out.println(String.format("    Instruction: %s", opCode.toInstructionString()));
        if (instr.isStackInstruction()) {
            System.out.println(String.format("    SP Increment: %d", instr.getStackPointerIncrement()));
        }
        for (int i = 0; i < instr.getOpCount(); ++i) {
            int opKind = instr.getOpKind(i);
            if (opKind == 24) {
                int size = MemorySize.getSize(instr.getMemorySize());
                if (size == 0) break;
                System.out.println(String.format("    Memory size: %d", size));
                break;
            }
            if (opKind != 0) continue;
            System.out.println("Op " + i + " is a register");
        }
    }

    public static void printInst(Code code, Instruction inst) {
        LinkedList<Instruction> temp = new LinkedList<Instruction>();
        temp.add(inst);
        CodeUtils.print(code, temp);
    }

    public static void print(Code code, List instructions) {
        CodeUtils.print(System.out, code, instructions);
    }

    public static void print(PrintStream out, Code code) {
        CodeUtils.print(out, code, code.getCode());
    }

    public static void print(PrintStream out, final Code code, List instructions) {
        SymbolResolver symResolver = new SymbolResolver(){

            @Override
            public SymbolResult getSymbol(Instruction instruction, int operand, int instructionOperand, long address, int addressSize) {
                Relocation reloc = code.getRelocation(instruction);
                if (reloc != null) {
                    return code.relocationToSymbol(reloc, operand, address);
                }
                if ("CALL rel32".equals(instruction.getOpCode().toInstructionString()) ? code.getLabel(address) != null : instruction.isIPRelativeMemoryOperand() && ("LEA r64, m".equals(instruction.getOpCode().toInstructionString()) ? code.getLabel(address) != null : ("MOV r64, r/m64".equals(instruction.getOpCode().toInstructionString()) ? code.getLabel(address) != null : "CALL r/m64".equals(instruction.getOpCode().toInstructionString()) && code.getLabel(address) != null))) {
                    return new SymbolResult(address, code.getLabel(address).getName());
                }
                return null;
            }
        };
        GasFormatter formatter = new GasFormatter(symResolver);
        formatter.getOptions().setDigitSeparator("`");
        formatter.getOptions().setFirstOperandCharIndex(10);
        formatter.getOptions().setGasSpaceAfterMemoryOperandComma(true);
        StringOutput output = new StringOutput();
        for (Instruction instr : instructions) {
            if (code.getLabel(instr.getIP()) != null) {
                out.println("");
                out.println(String.format("%016X", instr.getIP()) + " <" + code.getLabel(instr.getIP()).getName() + ">:");
            }
            formatter.format(instr, output);
            out.print(String.format("%016X", instr.getIP()));
            out.print(" ");
            int instrLen = instr.getLength();
            int byteBaseIndex = (int)(instr.getIP() - 0L);
            for (int i = 0; i < instrLen; ++i) {
                out.print(String.format("%02X", code.getCodeAsBytes()[byteBaseIndex + i]));
            }
            int missingBytes = 10 - instrLen;
            for (int i = 0; i < missingBytes; ++i) {
                out.print("  ");
            }
            out.print(" ");
            out.println(output.toStringAndReset());
        }
    }

    public static void print(Code code) {
        CodeUtils.print(code, code.getCode());
    }

    public static int compare(byte[] str1, byte[] str2, int a, int b) {
        int count = 0;
        while (count + a < str1.length && count + b < str2.length && str1[count + a] == str2[count + b]) {
            ++count;
        }
        return count;
    }

    public static int lcs(byte[] str1, byte[] str2) {
        int y;
        int x;
        int m = str1.length;
        int n = str2.length;
        int idxm = 0;
        int idxn = 0;
        int max = 0;
        int[][] lens = new int[m][n];
        for (x = 0; x < str1.length; ++x) {
            for (y = 0; y < str2.length; ++y) {
                lens[x][y] = CodeUtils.compare(str1, str2, x, y);
            }
        }
        for (x = 0; x < str1.length; ++x) {
            for (y = 0; y < str2.length; ++y) {
                if (lens[x][y] < max) continue;
                idxm = x;
                idxn = y;
                max = lens[x][y];
            }
        }
        CrystalUtils.print_stat("Max LCS is: " + max + " @ indices " + String.format("%016X", idxm) + ", " + String.format("%016X", idxn));
        return max;
    }
}

