/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.btf;

import com.github.icedland.iced.x86.ConstantOffsets;
import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.fmt.SymbolResult;
import crystalpalace.btf.CodeX64;
import crystalpalace.btf.CodeX86;
import crystalpalace.coff.COFFObject;
import crystalpalace.coff.Relocation;
import crystalpalace.coff.Symbol;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class Code {
    protected COFFObject object;
    protected byte[] code;
    protected List instructions = new LinkedList();
    protected Map labels = new HashMap();
    protected Map relocs = new HashMap();
    protected Map offsets = new HashMap();
    protected long startip = 0L;

    protected Code(COFFObject o) {
        this.object = o;
        this.code = this.object.getSection(".text").getRawData();
    }

    public static Code Init(COFFObject o) {
        if ("x64".equals(o.getMachine())) {
            return new CodeX64(o);
        }
        if ("x86".equals(o.getMachine())) {
            return new CodeX86(o);
        }
        throw new RuntimeException("Can't analyze code for " + o.getMachine());
    }

    public COFFObject getObject() {
        return this.object;
    }

    public byte[] getCodeAsBytes() {
        return this.code;
    }

    public ConstantOffsets getOffsets(Instruction instr) {
        return (ConstantOffsets)this.offsets.get(instr);
    }

    public abstract List disassemble();

    public Code setIP(long startip) {
        this.startip = startip;
        return this;
    }

    public Code analyze() {
        this.instructions = this.disassemble();
        for (Symbol temp : this.object.getSection(".text").getSymbols()) {
            if (temp.isFunction()) {
                this.labels.put(temp.getValue(), temp);
                continue;
            }
            if (temp.isGlobalVariable()) {
                this.labels.put(temp.getValue(), temp);
                continue;
            }
            if (temp.getType() != 0 || temp.getValue() <= 0L) continue;
            throw new RuntimeException("Caught a candidate symbol, non-function/non-code: " + temp);
        }
        for (Relocation reloc : this.object.getSection(".text").getRelocations()) {
            this.relocs.put(reloc.getVirtualAddress(), reloc);
        }
        return this;
    }

    public boolean isFunction(String name) {
        Symbol symb = this.object.getSymbol(name);
        if (symb == null) {
            throw new RuntimeException("No symbol for " + name + " to determine func or not");
        }
        return symb.isFunction();
    }

    public Symbol getLabel(long addr) {
        return (Symbol)this.labels.get(addr);
    }

    public boolean hasOffsets(Instruction instr) {
        return this.offsets.containsKey(instr);
    }

    public boolean hasRelocation(Instruction instr) {
        return this.getRelocation(instr) != null;
    }

    public abstract Relocation getRelocation(Instruction var1);

    public abstract SymbolResult relocationToSymbol(Relocation var1, int var2, long var3);

    public Map getCodeByFunction() {
        LinkedHashMap rv = new LinkedHashMap();
        LinkedList<Instruction> current = new LinkedList<Instruction>();
        for (Instruction instr : this.getCode()) {
            if (this.getLabel(instr.getIP()) != null) {
                current = new LinkedList();
                rv.put(this.getLabel(instr.getIP()).getName(), current);
            }
            current.add(instr);
        }
        return rv;
    }

    public List getCode() {
        return new LinkedList(this.instructions);
    }
}

