/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.btf;

import com.github.icedland.iced.x86.ICRegister;
import com.github.icedland.iced.x86.ICRegisters;
import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.asm.AsmMemoryOperand;
import com.github.icedland.iced.x86.asm.AsmRegister16;
import com.github.icedland.iced.x86.asm.AsmRegister32;
import com.github.icedland.iced.x86.asm.AsmRegister64;
import com.github.icedland.iced.x86.asm.AsmRegister8;
import com.github.icedland.iced.x86.asm.AsmRegisterSegment;
import com.github.icedland.iced.x86.asm.AsmRegisters;
import com.github.icedland.iced.x86.asm.CodeAssembler;
import crystalpalace.btf.AddInstruction;
import crystalpalace.btf.Code;
import crystalpalace.btf.RebuildStep;
import crystalpalace.coff.COFFObject;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public abstract class BaseModify
implements AddInstruction {
    protected Code code = null;
    protected COFFObject object = null;
    protected List verbs = new LinkedList();
    protected boolean x64 = false;
    protected Random rng = new Random();

    public int nextInt(int max) {
        if (max == Integer.MIN_VALUE) {
            return this.rng.nextInt();
        }
        return this.rng.nextInt(max);
    }

    public long nextLong() {
        return this.rng.nextLong();
    }

    public abstract void setupVerbs();

    public abstract boolean shouldModify(RebuildStep var1, Instruction var2);

    public void noMatch(CodeAssembler program, RebuildStep step, Instruction next) {
        program.addInstruction(next);
    }

    public BaseModify(Code code) {
        this.code = code;
        this.object = code.getObject();
        this.x64 = "x64".equals(this.object.getMachine());
        try {
            this.rng = SecureRandom.getInstanceStrong();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.setupVerbs();
    }

    @Override
    public void addInstruction(CodeAssembler program, RebuildStep step, Instruction next) {
        if (!this.shouldModify(step, next)) {
            program.addInstruction(next);
            return;
        }
        String istr = next.getOpCode().toInstructionString();
        for (ModifyVerb verb : this.verbs) {
            if (!verb.check(istr, next)) continue;
            verb.apply(program, step, next);
            return;
        }
        this.noMatch(program, step, next);
    }

    public AsmRegister8 toReg8(AsmRegister64 reg) {
        if (reg.get() == ICRegisters.rax) {
            return new AsmRegister8(ICRegisters.al);
        }
        if (reg.get() == ICRegisters.rbx) {
            return new AsmRegister8(ICRegisters.bl);
        }
        if (reg.get() == ICRegisters.rcx) {
            return new AsmRegister8(ICRegisters.cl);
        }
        if (reg.get() == ICRegisters.rdi) {
            return new AsmRegister8(ICRegisters.dil);
        }
        if (reg.get() == ICRegisters.rdx) {
            return new AsmRegister8(ICRegisters.dl);
        }
        if (reg.get() == ICRegisters.rsi) {
            return new AsmRegister8(ICRegisters.sil);
        }
        if (reg.get() == ICRegisters.r8) {
            return new AsmRegister8(ICRegisters.r8b);
        }
        if (reg.get() == ICRegisters.r9) {
            return new AsmRegister8(ICRegisters.r9b);
        }
        if (reg.get() == ICRegisters.r10) {
            return new AsmRegister8(ICRegisters.r10b);
        }
        if (reg.get() == ICRegisters.r11) {
            return new AsmRegister8(ICRegisters.r11b);
        }
        if (reg.get() == ICRegisters.r12) {
            return new AsmRegister8(ICRegisters.r12b);
        }
        if (reg.get() == ICRegisters.r13) {
            return new AsmRegister8(ICRegisters.r13b);
        }
        if (reg.get() == ICRegisters.r14) {
            return new AsmRegister8(ICRegisters.r14b);
        }
        if (reg.get() == ICRegisters.r15) {
            return new AsmRegister8(ICRegisters.r15b);
        }
        return null;
    }

    public AsmRegister16 toReg16(AsmRegister64 reg) {
        if (reg.get() == ICRegisters.rax) {
            return new AsmRegister16(ICRegisters.ax);
        }
        if (reg.get() == ICRegisters.rbx) {
            return new AsmRegister16(ICRegisters.bx);
        }
        if (reg.get() == ICRegisters.rcx) {
            return new AsmRegister16(ICRegisters.cx);
        }
        if (reg.get() == ICRegisters.rdi) {
            return new AsmRegister16(ICRegisters.di);
        }
        if (reg.get() == ICRegisters.rdx) {
            return new AsmRegister16(ICRegisters.dx);
        }
        if (reg.get() == ICRegisters.rsi) {
            return new AsmRegister16(ICRegisters.si);
        }
        if (reg.get() == ICRegisters.r8) {
            return new AsmRegister16(ICRegisters.r8w);
        }
        if (reg.get() == ICRegisters.r9) {
            return new AsmRegister16(ICRegisters.r9w);
        }
        if (reg.get() == ICRegisters.r10) {
            return new AsmRegister16(ICRegisters.r10w);
        }
        if (reg.get() == ICRegisters.r11) {
            return new AsmRegister16(ICRegisters.r11w);
        }
        if (reg.get() == ICRegisters.r12) {
            return new AsmRegister16(ICRegisters.r12w);
        }
        if (reg.get() == ICRegisters.r13) {
            return new AsmRegister16(ICRegisters.r13w);
        }
        if (reg.get() == ICRegisters.r14) {
            return new AsmRegister16(ICRegisters.r14w);
        }
        if (reg.get() == ICRegisters.r15) {
            return new AsmRegister16(ICRegisters.r15w);
        }
        return null;
    }

    public AsmRegister32 toReg32(AsmRegister64 reg) {
        if (reg.get() == ICRegisters.rax) {
            return new AsmRegister32(ICRegisters.eax);
        }
        if (reg.get() == ICRegisters.rbx) {
            return new AsmRegister32(ICRegisters.ebx);
        }
        if (reg.get() == ICRegisters.rcx) {
            return new AsmRegister32(ICRegisters.ecx);
        }
        if (reg.get() == ICRegisters.rdi) {
            return new AsmRegister32(ICRegisters.edi);
        }
        if (reg.get() == ICRegisters.rdx) {
            return new AsmRegister32(ICRegisters.edx);
        }
        if (reg.get() == ICRegisters.rsi) {
            return new AsmRegister32(ICRegisters.esi);
        }
        if (reg.get() == ICRegisters.r8) {
            return new AsmRegister32(ICRegisters.r8d);
        }
        if (reg.get() == ICRegisters.r9) {
            return new AsmRegister32(ICRegisters.r9d);
        }
        if (reg.get() == ICRegisters.r10) {
            return new AsmRegister32(ICRegisters.r10d);
        }
        if (reg.get() == ICRegisters.r11) {
            return new AsmRegister32(ICRegisters.r11d);
        }
        if (reg.get() == ICRegisters.r12) {
            return new AsmRegister32(ICRegisters.r12d);
        }
        if (reg.get() == ICRegisters.r13) {
            return new AsmRegister32(ICRegisters.r13d);
        }
        if (reg.get() == ICRegisters.r14) {
            return new AsmRegister32(ICRegisters.r14d);
        }
        if (reg.get() == ICRegisters.r15) {
            return new AsmRegister32(ICRegisters.r15d);
        }
        return null;
    }

    public AsmRegister64 getRandReg64(AsmRegister64 exclude) {
        AsmRegister64 cand;
        while ((cand = this.getRandReg64()).equals(exclude)) {
        }
        return cand;
    }

    public AsmRegister64 getRandReg64() {
        switch (this.nextInt(14)) {
            case 0: {
                return new AsmRegister64(ICRegisters.rax);
            }
            case 1: {
                return new AsmRegister64(ICRegisters.rbx);
            }
            case 2: {
                return new AsmRegister64(ICRegisters.rcx);
            }
            case 3: {
                return new AsmRegister64(ICRegisters.rdi);
            }
            case 4: {
                return new AsmRegister64(ICRegisters.rdx);
            }
            case 5: {
                return new AsmRegister64(ICRegisters.rsi);
            }
            case 6: {
                return new AsmRegister64(ICRegisters.r8);
            }
            case 7: {
                return new AsmRegister64(ICRegisters.r9);
            }
            case 8: {
                return new AsmRegister64(ICRegisters.r10);
            }
            case 9: {
                return new AsmRegister64(ICRegisters.r11);
            }
            case 10: {
                return new AsmRegister64(ICRegisters.r12);
            }
            case 11: {
                return new AsmRegister64(ICRegisters.r13);
            }
            case 12: {
                return new AsmRegister64(ICRegisters.r14);
            }
            case 13: {
                return new AsmRegister64(ICRegisters.r15);
            }
        }
        throw new RuntimeException("Missing case.");
    }

    public AsmMemoryOperand getStackPtr() {
        if (this.x64) {
            return AsmRegisters.mem_ptr(new AsmRegister64(ICRegisters.rsp), 0L);
        }
        return AsmRegisters.mem_ptr(new AsmRegister32(ICRegisters.esp), 0L);
    }

    public List pushad(CodeAssembler program) {
        LinkedList<Object> regs = new LinkedList<Object>();
        if (this.x64) {
            regs.add(new AsmRegister64(ICRegisters.rcx));
            regs.add(new AsmRegister64(ICRegisters.rdx));
            regs.add(new AsmRegister64(ICRegisters.r8));
            regs.add(new AsmRegister64(ICRegisters.r9));
            regs.add(new AsmRegister64(ICRegisters.r10));
            regs.add(new AsmRegister64(ICRegisters.r11));
        } else {
            regs.add(new AsmRegister32(ICRegisters.ecx));
            regs.add(new AsmRegister32(ICRegisters.edx));
        }
        Collections.shuffle(regs);
        Iterator i = regs.iterator();
        while (i.hasNext()) {
            Object temp;
            if (this.x64) {
                temp = (AsmRegister64)i.next();
                program.push((AsmRegister64)temp);
                continue;
            }
            temp = (AsmRegister32)i.next();
            program.push((AsmRegister32)temp);
        }
        return regs;
    }

    public void stackAlloc(CodeAssembler program, int x) {
        AsmRegister64 rsp = new AsmRegister64(ICRegisters.rsp);
        program.sub(rsp, x);
    }

    public void stackDealloc(CodeAssembler program, int x) {
        AsmRegister64 rsp = new AsmRegister64(ICRegisters.rsp);
        program.add(rsp, x);
    }

    public void popad(CodeAssembler program, List regs) {
        Collections.reverse(regs);
        Iterator i = regs.iterator();
        while (i.hasNext()) {
            Object temp;
            if (this.x64) {
                temp = (AsmRegister64)i.next();
                program.pop((AsmRegister64)temp);
                continue;
            }
            temp = (AsmRegister32)i.next();
            program.pop((AsmRegister32)temp);
        }
    }

    public AsmMemoryOperand getMemOperand(Instruction next) {
        if (next.getMemoryBase() == 0) {
            return null;
        }
        AsmMemoryOperand cand = null;
        if (next.getMemoryIndex() == 0) {
            cand = "x64".equals(this.object.getMachine()) ? AsmRegisters.mem_ptr(new AsmRegister64(new ICRegister(next.getMemoryBase())), next.getMemoryDisplacement64()) : AsmRegisters.mem_ptr(new AsmRegister32(new ICRegister(next.getMemoryBase())), (long)next.getMemoryDisplacement32());
        } else {
            if (next.getMemoryIndex() != 0) {
                return null;
            }
            cand = "x64".equals(this.object.getMachine()) ? AsmRegisters.mem_ptr(new AsmRegister64(new ICRegister(next.getMemoryBase())), new AsmRegister64(new ICRegister(next.getMemoryIndex())), next.getMemoryIndexScale(), next.getMemoryDisplacement64()) : AsmRegisters.mem_ptr(new AsmRegister32(new ICRegister(next.getMemoryBase())), new AsmRegister32(new ICRegister(next.getMemoryIndex())), next.getMemoryIndexScale(), (long)next.getMemoryDisplacement32());
        }
        if (next.getMemorySegment() == 76 || next.getMemorySegment() == 75) {
            AsmRegisterSegment seg = new AsmRegisterSegment(new ICRegister(next.getMemorySegment()));
            return cand.segment(seg);
        }
        return cand;
    }

    public AsmRegister32 getRandReg32(AsmRegister32 exclude) {
        AsmRegister32 cand;
        while ((cand = this.getRandReg32()).equals(exclude)) {
        }
        return cand;
    }

    public AsmRegister32 getReg32(List saved, AsmRegister32 exclude) {
        if (exclude == null) {
            return (AsmRegister32)saved.get(0);
        }
        for (AsmRegister32 reg : saved) {
            if (reg.equals(exclude)) continue;
            return reg;
        }
        return null;
    }

    public AsmRegister32 getRandReg32() {
        switch (this.nextInt(6)) {
            case 0: {
                return new AsmRegister32(ICRegisters.eax);
            }
            case 1: {
                return new AsmRegister32(ICRegisters.ebx);
            }
            case 2: {
                return new AsmRegister32(ICRegisters.ecx);
            }
            case 3: {
                return new AsmRegister32(ICRegisters.edi);
            }
            case 4: {
                return new AsmRegister32(ICRegisters.edx);
            }
            case 5: {
                return new AsmRegister32(ICRegisters.esi);
            }
        }
        throw new RuntimeException("Missing case.");
    }

    public static interface ModifyVerb {
        public boolean check(String var1, Instruction var2);

        public void apply(CodeAssembler var1, RebuildStep var2, Instruction var3);
    }
}

