/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.internal.info;

import com.github.icedland.iced.x86.internal.DataReader;

public final class CpuidFeatureInternalData {
    public static final int[][] toCpuidFeatures = CpuidFeatureInternalData.getCpuidFeatures();

    private CpuidFeatureInternalData() {
    }

    private static int[][] getCpuidFeatures() {
        byte[] data = CpuidFeatureInternalData.getCpuidFeaturesData();
        DataReader reader = new DataReader(data);
        reader.setIndex(25);
        int[][] cpuidFeatures = new int[199][];
        for (int i = 0; i < cpuidFeatures.length; ++i) {
            byte b = data[i / 8];
            int[] features = new int[(b >>> i % 8 & 1) + 1];
            for (int j = 0; j < features.length; ++j) {
                features[j] = reader.readByte();
            }
            cpuidFeatures[i] = features;
        }
        if (reader.canRead()) {
            throw new UnsupportedOperationException();
        }
        return cpuidFeatures;
    }

    private static byte[] getCpuidFeaturesData() {
        return new byte[]{0, 0, 1, -128, -3, 63, 0, 0, 16, -32, 0, 0, 16, 0, 0, 16, -128, 109, 0, 0, 0, 8, 8, 0, 28, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 14, 15, 16, 17, 18, 20, 21, 22, 23, 24, 26, 27, 28, 29, 30, 31, 31, 19, 31, 25, 32, 33, 19, 33, 20, 33, 21, 33, 22, 33, 23, 33, 24, 33, 25, 33, 26, 33, 27, 33, 28, 33, 29, 33, 31, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 55, 44, 56, 57, 58, 59, 60, 61, 62, 63, 15, 63, 31, 63, 33, 63, 65, 67, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 86, 15, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 105, 106, 107, 108, 109, 110, 55, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 31, 120, 33, 120, 121, 121, 66, 121, 68, 122, 31, 122, 33, 122, 123, 124, 125, 126, 127, -128, -127, -126, -125, -124, -123, -122, -121, -120, -119, -118, -117, -116, -115, -114, -113, -112, -111, -110, -109, -108, -107, -106, -106, -105, -104, -103, -102, -101, -100, -99, -98, 33, -98, -97, -96, -95, -94, -93, -92, -91, -90, -89, -88, -87, -86, -85, -84, 15, -83, 15, -82, 15, -81, -80, -79};
    }
}

