/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.internal.fmt;

import com.github.icedland.iced.x86.fmt.FormatterOptions;
import com.github.icedland.iced.x86.fmt.NumberFormattingOptions;
import com.github.icedland.iced.x86.internal.fmt.StringUtils;

@Deprecated
public final class NumberFormatter {
    private static final long SMALL_POSITIVE_NUMBER = 9L;
    private final StringBuilder sb;
    private static final long[] divs = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L, -8446744073709551616L};
    private static final String[] smallDecimalValues = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};

    public NumberFormatter(boolean dummy) {
        int CAP = 81;
        this.sb = new StringBuilder(81);
    }

    private static void toHexadecimal(StringBuilder sb, long value, int digitGroupSize, String digitSeparator, int digits, boolean upper, boolean leadingZero) {
        int hexHigh;
        if (digits == 0) {
            digits = 1;
            long tmp = value;
            while ((tmp >>>= 4) != 0L) {
                ++digits;
            }
        }
        int n = hexHigh = upper ? 55 : 87;
        if (leadingZero && digits < 17 && (int)(value >>> (digits - 1 << 2) & 0xFL) > 9) {
            ++digits;
        }
        boolean useDigitSep = digitGroupSize > 0 && !StringUtils.isNullOrEmpty(digitSeparator);
        for (int i = 0; i < digits; ++i) {
            int digit;
            int index = digits - i - 1;
            int n2 = digit = index >= 16 ? 0 : (int)(value >>> (index << 2) & 0xFL);
            if (digit > 9) {
                sb.append((char)(digit + hexHigh));
            } else {
                sb.append((char)(digit + 48));
            }
            if (!useDigitSep || index <= 0 || index % digitGroupSize != 0) continue;
            sb.append(digitSeparator);
        }
    }

    private static void toDecimal(StringBuilder sb, long value, int digitGroupSize, String digitSeparator, int digits) {
        if (digits == 0) {
            digits = 1;
            long tmp = value;
            while ((tmp = Long.divideUnsigned(tmp, 10L)) != 0L) {
                ++digits;
            }
        }
        boolean useDigitSep = digitGroupSize > 0 && !StringUtils.isNullOrEmpty(digitSeparator);
        long[] divs = NumberFormatter.divs;
        for (int i = 0; i < digits; ++i) {
            int index = digits - i - 1;
            if (Long.compareUnsigned(index, divs.length) < 0) {
                int digit = (int)Long.remainderUnsigned(Long.divideUnsigned(value, divs[index]), 10L);
                sb.append((char)(digit + 48));
            } else {
                sb.append('0');
            }
            if (!useDigitSep || index <= 0 || index % digitGroupSize != 0) continue;
            sb.append(digitSeparator);
        }
    }

    private static void toOctal(StringBuilder sb, long value, int digitGroupSize, String digitSeparator, int digits, String prefix) {
        if (digits == 0) {
            digits = 1;
            long tmp = value;
            while ((tmp >>>= 3) != 0L) {
                ++digits;
            }
        }
        if (!StringUtils.isNullOrEmpty(prefix)) {
            if (prefix.equals("0")) {
                if (digits < 23 && (int)(value >>> (digits - 1) * 3 & 7L) != 0) {
                    ++digits;
                }
            } else {
                sb.append(prefix);
            }
        }
        boolean useDigitSep = digitGroupSize > 0 && !StringUtils.isNullOrEmpty(digitSeparator);
        for (int i = 0; i < digits; ++i) {
            int index = digits - i - 1;
            int digit = index >= 22 ? 0 : (int)(value >>> index * 3 & 7L);
            sb.append((char)(digit + 48));
            if (!useDigitSep || index <= 0 || index % digitGroupSize != 0) continue;
            sb.append(digitSeparator);
        }
    }

    private static void toBinary(StringBuilder sb, long value, int digitGroupSize, String digitSeparator, int digits) {
        if (digits == 0) {
            digits = 1;
            long tmp = value;
            while ((tmp >>>= 1) != 0L) {
                ++digits;
            }
        }
        boolean useDigitSep = digitGroupSize > 0 && !StringUtils.isNullOrEmpty(digitSeparator);
        for (int i = 0; i < digits; ++i) {
            int index = digits - i - 1;
            int digit = index >= 64 ? 0 : (int)(value >>> index & 1L);
            sb.append((char)(digit + 48));
            if (!useDigitSep || index <= 0 || index % digitGroupSize != 0) continue;
            sb.append(digitSeparator);
        }
    }

    private static int getFlags(boolean leadingZeros, boolean smallHexNumbersInDecimal) {
        int flags = 0;
        if (leadingZeros) {
            flags |= 2;
        }
        if (smallHexNumbersInDecimal) {
            flags |= 4;
        }
        return flags;
    }

    public String formatInt8(FormatterOptions formatterOptions, NumberFormattingOptions options, byte value) {
        int flags = NumberFormatter.getFlags(options.leadingZeros, options.smallHexNumbersInDecimal);
        if (value < 0) {
            flags |= 1;
            value = -value;
        }
        return this.formatUnsignedInteger(formatterOptions, options, value & 0xFF, 8, flags);
    }

    public String formatInt16(FormatterOptions formatterOptions, NumberFormattingOptions options, short value) {
        int flags = NumberFormatter.getFlags(options.leadingZeros, options.smallHexNumbersInDecimal);
        if (value < 0) {
            flags |= 1;
            value = -value;
        }
        return this.formatUnsignedInteger(formatterOptions, options, value & 0xFFFF, 16, flags);
    }

    public String formatInt32(FormatterOptions formatterOptions, NumberFormattingOptions options, int value) {
        int flags = NumberFormatter.getFlags(options.leadingZeros, options.smallHexNumbersInDecimal);
        if (value < 0) {
            flags |= 1;
            value = -value;
        }
        return this.formatUnsignedInteger(formatterOptions, options, (long)value & 0xFFFFFFFFL, 32, flags);
    }

    public String formatInt64(FormatterOptions formatterOptions, NumberFormattingOptions options, long value) {
        int flags = NumberFormatter.getFlags(options.leadingZeros, options.smallHexNumbersInDecimal);
        if (value < 0L) {
            flags |= 1;
            value = -value;
        }
        return this.formatUnsignedInteger(formatterOptions, options, value, 64, flags);
    }

    public String formatUInt8(FormatterOptions formatterOptions, NumberFormattingOptions options, byte value) {
        return this.formatUnsignedInteger(formatterOptions, options, value & 0xFF, 8, NumberFormatter.getFlags(options.leadingZeros, options.smallHexNumbersInDecimal));
    }

    public String formatUInt16(FormatterOptions formatterOptions, NumberFormattingOptions options, short value) {
        return this.formatUnsignedInteger(formatterOptions, options, value & 0xFFFF, 16, NumberFormatter.getFlags(options.leadingZeros, options.smallHexNumbersInDecimal));
    }

    public String formatUInt32(FormatterOptions formatterOptions, NumberFormattingOptions options, int value) {
        return this.formatUnsignedInteger(formatterOptions, options, (long)value & 0xFFFFFFFFL, 32, NumberFormatter.getFlags(options.leadingZeros, options.smallHexNumbersInDecimal));
    }

    public String formatUInt64(FormatterOptions formatterOptions, NumberFormattingOptions options, long value) {
        return this.formatUnsignedInteger(formatterOptions, options, value, 64, NumberFormatter.getFlags(options.leadingZeros, options.smallHexNumbersInDecimal));
    }

    public String formatDisplUInt8(FormatterOptions formatterOptions, NumberFormattingOptions options, byte value) {
        return this.formatUnsignedInteger(formatterOptions, options, value & 0xFF, 8, NumberFormatter.getFlags(options.displacementLeadingZeros, options.smallHexNumbersInDecimal));
    }

    public String formatDisplUInt16(FormatterOptions formatterOptions, NumberFormattingOptions options, short value) {
        return this.formatUnsignedInteger(formatterOptions, options, value & 0xFFFF, 16, NumberFormatter.getFlags(options.displacementLeadingZeros, options.smallHexNumbersInDecimal));
    }

    public String formatDisplUInt32(FormatterOptions formatterOptions, NumberFormattingOptions options, int value) {
        return this.formatUnsignedInteger(formatterOptions, options, (long)value & 0xFFFFFFFFL, 32, NumberFormatter.getFlags(options.displacementLeadingZeros, options.smallHexNumbersInDecimal));
    }

    public String formatDisplUInt64(FormatterOptions formatterOptions, NumberFormattingOptions options, long value) {
        return this.formatUnsignedInteger(formatterOptions, options, value, 64, NumberFormatter.getFlags(options.displacementLeadingZeros, options.smallHexNumbersInDecimal));
    }

    public String formatUInt16(FormatterOptions formatterOptions, NumberFormattingOptions options, short value, boolean leadingZeros) {
        return this.formatUnsignedInteger(formatterOptions, options, value & 0xFFFF, 16, NumberFormatter.getFlags(leadingZeros, options.smallHexNumbersInDecimal));
    }

    public String formatUInt32(FormatterOptions formatterOptions, NumberFormattingOptions options, int value, boolean leadingZeros) {
        return this.formatUnsignedInteger(formatterOptions, options, (long)value & 0xFFFFFFFFL, 32, NumberFormatter.getFlags(leadingZeros, options.smallHexNumbersInDecimal));
    }

    public String formatUInt64(FormatterOptions formatterOptions, NumberFormattingOptions options, long value, boolean leadingZeros) {
        return this.formatUnsignedInteger(formatterOptions, options, value, 64, NumberFormatter.getFlags(leadingZeros, options.smallHexNumbersInDecimal));
    }

    private String formatUnsignedInteger(FormatterOptions formatterOptions, NumberFormattingOptions options, long value, int valueSize, int flags) {
        String suffix;
        this.sb.setLength(0);
        if ((flags & 1) != 0) {
            this.sb.append('-');
        }
        switch (options.numberBase) {
            case 0: {
                if ((flags & 4) != 0 && Long.compareUnsigned(value, 9L) <= 0) {
                    if (StringUtils.isNullOrEmpty(formatterOptions.getDecimalPrefix()) && StringUtils.isNullOrEmpty(formatterOptions.getDecimalSuffix())) {
                        return smallDecimalValues[(int)value];
                    }
                    if (!StringUtils.isNullOrEmpty(formatterOptions.getDecimalPrefix())) {
                        this.sb.append(formatterOptions.getDecimalPrefix());
                    }
                    this.sb.append(smallDecimalValues[(int)value]);
                    suffix = formatterOptions.getDecimalSuffix();
                    break;
                }
                if (!StringUtils.isNullOrEmpty(options.prefix)) {
                    this.sb.append(options.prefix);
                }
                NumberFormatter.toHexadecimal(this.sb, value, options.digitGroupSize, options.digitSeparator, (flags & 2) != 0 ? valueSize + 3 >>> 2 : 0, options.uppercaseHex, options.addLeadingZeroToHexNumbers && StringUtils.isNullOrEmpty(options.prefix));
                suffix = options.suffix;
                break;
            }
            case 1: {
                if (!StringUtils.isNullOrEmpty(options.prefix)) {
                    this.sb.append(options.prefix);
                }
                NumberFormatter.toDecimal(this.sb, value, options.digitGroupSize, options.digitSeparator, 0);
                suffix = options.suffix;
                break;
            }
            case 2: {
                NumberFormatter.toOctal(this.sb, value, options.digitGroupSize, options.digitSeparator, (flags & 2) != 0 ? (valueSize + 2) / 3 : 0, options.prefix);
                suffix = options.suffix;
                break;
            }
            case 3: {
                if (!StringUtils.isNullOrEmpty(options.prefix)) {
                    this.sb.append(options.prefix);
                }
                NumberFormatter.toBinary(this.sb, value, options.digitGroupSize, options.digitSeparator, (flags & 2) != 0 ? valueSize : 0);
                suffix = options.suffix;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (!StringUtils.isNullOrEmpty(suffix)) {
            this.sb.append(suffix);
        }
        return this.sb.toString();
    }

    private static final class Flags {
        static final int NONE = 0;
        static final int ADD_MINUS_SIGN = 1;
        static final int LEADING_ZEROS = 2;
        static final int SMALL_HEX_NUMBERS_IN_DECIMAL = 4;

        private Flags() {
        }
    }
}

