/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.internal.fmt;

import com.github.icedland.iced.x86.Code;
import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.fmt.FormatterOptions;
import com.github.icedland.iced.x86.fmt.FormatterOutput;

@Deprecated
public final class FormatterUtils {
    private static final String[] spaceStrings = FormatterUtils.createStrings(' ', 20);
    private static final String[] tabStrings = FormatterUtils.createStrings('\t', 6);

    private static String[] createStrings(char c, int max) {
        String[] strings = new String[max];
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            sb.append(c);
            strings[i] = sb.toString();
        }
        return strings;
    }

    public static void addTabs(FormatterOutput output, int column, int firstOperandCharIndex, int tabSize) {
        int max_firstOperandCharIndex = 256;
        if (firstOperandCharIndex < 0) {
            firstOperandCharIndex = 0;
        } else if (firstOperandCharIndex > 256) {
            firstOperandCharIndex = 256;
        }
        if (tabSize <= 0) {
            int charsLeft = firstOperandCharIndex - column;
            if (charsLeft <= 0) {
                charsLeft = 1;
            }
            FormatterUtils.addStrings(output, spaceStrings, charsLeft);
        } else {
            int spaces;
            int endColRoundedDown;
            boolean addedTabs;
            int endCol = firstOperandCharIndex;
            if (endCol <= column) {
                endCol = column + 1;
            }
            boolean bl = addedTabs = (endColRoundedDown = endCol / tabSize * tabSize) > column;
            if (addedTabs) {
                int tabs = (endColRoundedDown - column / tabSize * tabSize) / tabSize;
                FormatterUtils.addStrings(output, tabStrings, tabs);
                column = endColRoundedDown;
            }
            if ((spaces = firstOperandCharIndex - column) > 0) {
                FormatterUtils.addStrings(output, spaceStrings, spaces);
            } else if (!addedTabs) {
                FormatterUtils.addStrings(output, spaceStrings, 1);
            }
        }
    }

    private static void addStrings(FormatterOutput output, String[] strings, int count) {
        while (count > 0) {
            int n = count;
            if (n >= strings.length) {
                n = strings.length;
            }
            output.write(strings[n - 1], 0);
            count -= n;
        }
    }

    public static boolean isCall(int kind) {
        return kind == 3 || kind == 5;
    }

    public static int getFlowControl(Instruction instruction) {
        switch (instruction.getCode()) {
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 699: 
            case 700: 
            case 701: 
            case 4563: 
            case 4564: {
                return 1;
            }
            case 657: 
            case 658: 
            case 659: 
            case 660: 
            case 661: 
            case 662: 
            case 663: 
            case 664: 
            case 665: 
            case 666: 
            case 667: 
            case 668: 
            case 669: 
            case 670: 
            case 671: 
            case 672: 
            case 673: 
            case 674: 
            case 675: 
            case 676: 
            case 677: 
            case 678: 
            case 679: 
            case 680: 
            case 681: 
            case 682: 
            case 683: 
            case 684: {
                return 0;
            }
            case 691: 
            case 692: 
            case 693: {
                return 3;
            }
            case 694: 
            case 695: 
            case 696: 
            case 1854: 
            case 1855: 
            case 1856: 
            case 1857: 
            case 1858: 
            case 1859: 
            case 1860: 
            case 1861: 
            case 1862: 
            case 1863: 
            case 1864: 
            case 1865: 
            case 1866: 
            case 1867: 
            case 1868: 
            case 1869: 
            case 1870: 
            case 1871: 
            case 1872: 
            case 1873: 
            case 1874: 
            case 1875: 
            case 1876: 
            case 1877: 
            case 1878: 
            case 1879: 
            case 1880: 
            case 1881: 
            case 1882: 
            case 1883: 
            case 1884: 
            case 1885: 
            case 1886: 
            case 1887: 
            case 1888: 
            case 1889: 
            case 1890: 
            case 1891: 
            case 1892: 
            case 1893: 
            case 1894: 
            case 1895: 
            case 1896: 
            case 1897: 
            case 1898: 
            case 1899: 
            case 1900: 
            case 1901: 
            case 2095: 
            case 2096: 
            case 4582: 
            case 4583: {
                return 2;
            }
            case 312: 
            case 313: {
                return 5;
            }
            case 697: 
            case 698: {
                return 4;
            }
            case 406: 
            case 407: {
                return 6;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static boolean showRepOrRepePrefix(int code, FormatterOptions options) {
        return FormatterUtils.showRepOrRepePrefix(code, options.getShowUselessPrefixes());
    }

    public static boolean showRepnePrefix(int code, FormatterOptions options) {
        return FormatterUtils.showRepnePrefix(code, options.getShowUselessPrefixes());
    }

    public static int getSegmentRegisterPrefixKind(int register) {
        assert (register == 71 || register == 72 || register == 73 || register == 74 || register == 75 || register == 76) : register;
        return register - 71 + 0;
    }

    public static boolean showIndexScale(Instruction instruction, FormatterOptions options) {
        return options.getShowUselessPrefixes() || !Code.ignoresIndex(instruction.getCode());
    }

    public static boolean showSegmentPrefix(int defaultSegReg, Instruction instruction, FormatterOptions options) {
        return FormatterUtils.showSegmentPrefix(defaultSegReg, instruction, options.getShowUselessPrefixes());
    }

    public static boolean canShowRoundingControl(Instruction instruction, FormatterOptions options) {
        switch (instruction.getCode()) {
            case 1105: 
            case 1786: 
            case 1804: 
            case 2383: {
                return options.getShowUselessPrefixes();
            }
        }
        return true;
    }

    public static boolean isNotrackPrefixBranch(int code) {
        return Integer.compareUnsigned(code - 763, 2) <= 0 || Integer.compareUnsigned(code - 757, 2) <= 0;
    }

    private static boolean isCode64(int codeSize) {
        return codeSize == 3 || codeSize == 0;
    }

    private static int getDefaultSegmentRegister(Instruction instruction) {
        int baseReg = instruction.getMemoryBase();
        if (baseReg == 26 || baseReg == 42 || baseReg == 41 || baseReg == 58 || baseReg == 57) {
            return 73;
        }
        return 74;
    }

    public static boolean showSegmentPrefix(int defaultSegReg, Instruction instruction, boolean showUselessPrefixes) {
        if (Code.ignoresSegment(instruction.getCode())) {
            return showUselessPrefixes;
        }
        int prefixSeg = instruction.getSegmentPrefix();
        assert (prefixSeg != 0) : prefixSeg;
        if (FormatterUtils.isCode64(instruction.getCodeSize())) {
            if (prefixSeg == 75 || prefixSeg == 76) {
                return true;
            }
            return showUselessPrefixes;
        }
        if (defaultSegReg == 0) {
            defaultSegReg = FormatterUtils.getDefaultSegmentRegister(instruction);
        }
        if (prefixSeg != defaultSegReg) {
            return true;
        }
        return showUselessPrefixes;
    }

    public static boolean showRepOrRepePrefix(int code, boolean showUselessPrefixes) {
        if (showUselessPrefixes || FormatterUtils.isRepRepeRepneInstruction(code)) {
            return true;
        }
        switch (code) {
            case 394: 
            case 395: 
            case 396: {
                return true;
            }
        }
        return showUselessPrefixes;
    }

    public static boolean showRepnePrefix(int code, boolean showUselessPrefixes) {
        if (showUselessPrefixes || FormatterUtils.isRepRepeRepneInstruction(code)) {
            return true;
        }
        return showUselessPrefixes;
    }

    public static boolean isRepeOrRepneInstruction(int code) {
        switch (code) {
            case 335: 
            case 336: 
            case 337: 
            case 338: 
            case 351: 
            case 352: 
            case 353: 
            case 354: {
                return true;
            }
        }
        return false;
    }

    private static boolean isRepRepeRepneInstruction(int code) {
        switch (code) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 337: 
            case 338: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 347: 
            case 348: 
            case 349: 
            case 350: 
            case 351: 
            case 352: 
            case 353: 
            case 354: 
            case 1958: 
            case 1959: 
            case 1960: 
            case 1961: 
            case 1962: 
            case 1963: 
            case 1964: 
            case 1965: 
            case 1966: 
            case 1969: 
            case 1970: 
            case 1971: 
            case 1972: 
            case 1973: 
            case 1974: 
            case 1975: 
            case 1976: 
            case 1977: 
            case 1978: 
            case 1979: 
            case 1980: 
            case 1981: 
            case 1982: 
            case 1983: 
            case 1984: 
            case 1985: 
            case 1986: 
            case 4312: 
            case 4313: 
            case 4314: 
            case 4315: 
            case 4316: 
            case 4317: 
            case 4818: 
            case 4819: 
            case 4820: 
            case 4821: 
            case 4822: 
            case 4823: 
            case 4824: 
            case 4825: 
            case 4826: 
            case 4827: 
            case 4828: 
            case 4829: 
            case 4830: 
            case 4831: 
            case 4832: {
                return true;
            }
        }
        return false;
    }
}

