/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt.nasm;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.fmt.FormatterOptions;
import com.github.icedland.iced.x86.fmt.nasm.InstrInfo;
import com.github.icedland.iced.x86.fmt.nasm.InstrOpInfo;
import com.github.icedland.iced.x86.internal.fmt.FormatterString;

final class SimpleInstrInfo_XLAT
extends InstrInfo {
    private final FormatterString mnemonic;

    SimpleInstrInfo_XLAT(String mnemonic) {
        this.mnemonic = new FormatterString(mnemonic);
    }

    @Override
    InstrOpInfo getOpInfo(FormatterOptions options, Instruction instruction) {
        int baseReg;
        switch (instruction.getCodeSize()) {
            case 0: {
                baseReg = instruction.getMemoryBase();
                break;
            }
            case 1: {
                baseReg = 24;
                break;
            }
            case 2: {
                baseReg = 40;
                break;
            }
            case 3: {
                baseReg = 56;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        int flags = 0;
        int memBaseReg = instruction.getMemoryBase();
        if (memBaseReg != baseReg) {
            if (memBaseReg == 24) {
                flags |= 0x20;
            } else if (memBaseReg == 40) {
                flags |= 0x40;
            } else if (memBaseReg == 56) {
                flags |= 0x60;
            }
        }
        InstrOpInfo info = new InstrOpInfo();
        info.flags = flags;
        info.mnemonic = this.mnemonic;
        return info;
    }
}

