/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt.masm;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.fmt.FormatterOptions;
import com.github.icedland.iced.x86.fmt.masm.InstrInfo;
import com.github.icedland.iced.x86.fmt.masm.InstrOpInfo;
import com.github.icedland.iced.x86.internal.fmt.FormatterString;
import com.github.icedland.iced.x86.internal.fmt.FormatterUtils;

final class SimpleInstrInfo_AY
extends InstrInfo {
    private final FormatterString mnemonic_args;
    private final FormatterString mnemonic_no_args;
    private final int flags = 24;

    SimpleInstrInfo_AY(String mnemonic_args, String mnemonic_no_args) {
        this.mnemonic_args = new FormatterString(mnemonic_args);
        this.mnemonic_no_args = new FormatterString(mnemonic_no_args);
    }

    @Override
    InstrOpInfo getOpInfo(FormatterOptions options, Instruction instruction) {
        InstrOpInfo info;
        boolean shortForm;
        int shortFormOpKind;
        switch (instruction.getCodeSize()) {
            case 0: {
                shortFormOpKind = instruction.getOp1Kind();
                break;
            }
            case 1: {
                shortFormOpKind = 21;
                break;
            }
            case 2: {
                shortFormOpKind = 22;
                break;
            }
            case 3: {
                shortFormOpKind = 23;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        boolean bl = shortForm = instruction.getOp1Kind() == shortFormOpKind && (instruction.getSegmentPrefix() == 0 || !FormatterUtils.showSegmentPrefix(74, instruction, options));
        if (!shortForm) {
            info = new InstrOpInfo();
            info.flags = 24;
            info.mnemonic = this.mnemonic_args;
            info.opCount = 1;
            info.op0Kind = (byte)instruction.getOp1Kind();
            info.op0Index = 1;
        } else {
            info = new InstrOpInfo();
            info.flags = 24;
            info.mnemonic = this.mnemonic_no_args;
        }
        return info;
    }
}

