/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.fmt.SymbolResult;
import com.github.icedland.iced.x86.fmt.TextInfo;
import com.github.icedland.iced.x86.fmt.TextPart;

public abstract class FormatterOutput {
    public abstract void write(String var1, int var2);

    public void writePrefix(Instruction instruction, String text, int prefix) {
        this.write(text, 2);
    }

    public void writeMnemonic(Instruction instruction, String text) {
        this.write(text, 3);
    }

    public void writeNumber(Instruction instruction, int operand, int instructionOperand, String text, long value, int numberKind, int kind) {
        this.write(text, kind);
    }

    public void writeDecorator(Instruction instruction, int operand, int instructionOperand, String text, int decorator) {
        this.write(text, 9);
    }

    public void writeRegister(Instruction instruction, int operand, int instructionOperand, String text, int register) {
        this.write(text, 8);
    }

    public void writeSymbol(Instruction instruction, int operand, int instructionOperand, long address, SymbolResult symbol) {
        TextInfo text = symbol.text;
        TextPart[] array = text.textArray;
        if (array != null) {
            for (TextPart part : array) {
                this.write(part.text, part.color);
            }
        } else if (text.text != null) {
            this.write(text.text.text, text.text.color);
        }
    }
}

