/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.enc;

import com.github.icedland.iced.x86.ConstantOffsets;
import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.enc.Block;
import com.github.icedland.iced.x86.enc.BlockData;
import com.github.icedland.iced.x86.enc.BlockEncoder;
import com.github.icedland.iced.x86.enc.Encoder;
import com.github.icedland.iced.x86.enc.Instr;
import com.github.icedland.iced.x86.enc.TargetInstr;
import com.github.icedland.iced.x86.enc.TryEncodeResult;

final class SimpleBranchInstr
extends Instr {
    private final byte bitness;
    private Instruction instruction;
    private TargetInstr targetInstr;
    private BlockData pointerData;
    private byte instrKind;
    private final byte shortInstructionSize;
    private final byte nearInstructionSize;
    private final byte longInstructionSize;
    private final byte nativeInstructionSize;
    private final short nativeCode;

    public SimpleBranchInstr(BlockEncoder blockEncoder, Block block, Instruction instruction) {
        super(block, instruction.getIP());
        this.bitness = (byte)blockEncoder.getBitness();
        this.instruction = instruction;
        this.instrKind = (byte)4;
        if (!blockEncoder.fixBranches()) {
            this.instrKind = 0;
            Instruction instrCopy = instruction.copy();
            instrCopy.setNearBranch64(0L);
            this.size = blockEncoder.getInstructionSize(instrCopy, 0L);
            this.shortInstructionSize = 0;
            this.nearInstructionSize = 0;
            this.longInstructionSize = 0;
            this.nativeInstructionSize = 0;
            this.nativeCode = 0;
        } else {
            Instruction instrCopy = instruction.copy();
            instrCopy.setNearBranch64(0L);
            this.shortInstructionSize = (byte)blockEncoder.getInstructionSize(instrCopy, 0L);
            this.nativeCode = (short)SimpleBranchInstr.toNativeBranchCode(instruction.getCode(), blockEncoder.getBitness());
            if (this.nativeCode == instruction.getCode()) {
                this.nativeInstructionSize = this.shortInstructionSize;
            } else {
                instrCopy = instruction.copy();
                instrCopy.setCode(this.nativeCode & 0xFFFF);
                instrCopy.setNearBranch64(0L);
                this.nativeInstructionSize = (byte)blockEncoder.getInstructionSize(instrCopy, 0L);
            }
            switch (blockEncoder.getBitness()) {
                case 16: {
                    this.nearInstructionSize = (byte)(this.nativeInstructionSize + 2 + 3);
                    break;
                }
                case 32: 
                case 64: {
                    this.nearInstructionSize = (byte)(this.nativeInstructionSize + 2 + 5);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            if (blockEncoder.getBitness() == 64) {
                this.longInstructionSize = (byte)(this.nativeInstructionSize + 2 + 6);
                this.size = Math.max(Math.max(this.shortInstructionSize, this.nearInstructionSize), this.longInstructionSize);
            } else {
                this.longInstructionSize = 0;
                this.size = Math.max(this.shortInstructionSize, this.nearInstructionSize);
            }
        }
    }

    static int toNativeBranchCode(int code, int bitness) {
        int c64;
        int c32;
        int c16;
        switch (code) {
            case 657: 
            case 658: {
                c16 = 657;
                c32 = 658;
                c64 = 0;
                break;
            }
            case 659: 
            case 660: 
            case 661: {
                c16 = 659;
                c32 = 660;
                c64 = 661;
                break;
            }
            case 662: 
            case 663: {
                c16 = 662;
                c32 = 0;
                c64 = 663;
                break;
            }
            case 664: 
            case 665: {
                c16 = 664;
                c32 = 665;
                c64 = 0;
                break;
            }
            case 666: 
            case 667: 
            case 668: {
                c16 = 666;
                c32 = 667;
                c64 = 668;
                break;
            }
            case 669: 
            case 670: {
                c16 = 669;
                c32 = 0;
                c64 = 670;
                break;
            }
            case 671: 
            case 672: {
                c16 = 671;
                c32 = 672;
                c64 = 0;
                break;
            }
            case 673: 
            case 674: 
            case 675: {
                c16 = 673;
                c32 = 674;
                c64 = 675;
                break;
            }
            case 676: 
            case 677: {
                c16 = 676;
                c32 = 0;
                c64 = 677;
                break;
            }
            case 678: 
            case 679: {
                c16 = 678;
                c32 = 679;
                c64 = 0;
                break;
            }
            case 680: 
            case 681: 
            case 682: {
                c16 = 680;
                c32 = 681;
                c64 = 682;
                break;
            }
            case 683: 
            case 684: {
                c16 = 683;
                c32 = 0;
                c64 = 684;
                break;
            }
            default: {
                throw new IllegalArgumentException("code");
            }
        }
        switch (bitness) {
            case 16: {
                return c16;
            }
            case 32: {
                return c32;
            }
            case 64: {
                return c64;
            }
        }
        throw new IllegalArgumentException("bitness");
    }

    @Override
    void initialize(BlockEncoder blockEncoder) {
        this.targetInstr = blockEncoder.getTarget(this.instruction.getNearBranchTarget());
    }

    @Override
    boolean optimize(long gained) {
        return this.tryOptimize(gained);
    }

    private boolean tryOptimize(long gained) {
        boolean useNear;
        if (this.instrKind == 0 || this.instrKind == 1) {
            this.done = true;
            return false;
        }
        long targetAddress = this.targetInstr.getAddress();
        long nextRip = this.ip + (long)this.shortInstructionSize;
        long diff = targetAddress - nextRip;
        diff = SimpleBranchInstr.convertDiffToBitnessDiff(this.bitness, SimpleBranchInstr.correctDiff(this.targetInstr.isInBlock(this.block), diff, gained));
        if (-128L <= diff && diff <= 127L) {
            if (this.pointerData != null) {
                this.pointerData.isValid = false;
            }
            this.instrKind = 1;
            this.size = this.shortInstructionSize;
            this.done = true;
            return true;
        }
        boolean bl = useNear = this.bitness != 64 || this.targetInstr.isInBlock(this.block);
        if (!useNear) {
            targetAddress = this.targetInstr.getAddress();
            nextRip = this.ip + (long)this.nearInstructionSize;
            diff = targetAddress - nextRip;
            diff = SimpleBranchInstr.convertDiffToBitnessDiff(this.bitness, SimpleBranchInstr.correctDiff(this.targetInstr.isInBlock(this.block), diff, gained));
            boolean bl2 = useNear = Integer.MIN_VALUE <= diff && diff <= Integer.MAX_VALUE;
        }
        if (useNear) {
            if (this.pointerData != null) {
                this.pointerData.isValid = false;
            }
            if (diff < -1920L || diff > 1905L) {
                this.done = true;
            }
            this.instrKind = (byte)2;
            this.size = this.nearInstructionSize;
            return true;
        }
        if (this.pointerData == null) {
            this.pointerData = this.block.allocPointerLocation();
        }
        this.instrKind = (byte)3;
        return false;
    }

    @Override
    String tryEncode(Encoder encoder, TryEncodeResult result) {
        switch (this.instrKind) {
            case 0: 
            case 1: {
                result.isOriginalInstruction = true;
                Instruction instr = this.instruction.copy();
                instr.setNearBranch64(this.targetInstr.getAddress());
                Object encResult = encoder.tryEncode(instr, this.ip);
                if (encResult instanceof String) {
                    return SimpleBranchInstr.createErrorMessage((String)encResult, instr);
                }
                result.constantOffsets = encoder.getConstantOffsets();
                return null;
            }
            case 2: {
                int codeNear;
                result.isOriginalInstruction = false;
                result.constantOffsets = new ConstantOffsets();
                Instruction instr = this.instruction.copy();
                instr.setCode(this.nativeCode & 0xFFFF);
                instr.setNearBranch64(this.ip + (long)this.nativeInstructionSize + 2L);
                Object encResult = encoder.tryEncode(instr, this.ip);
                if (encResult instanceof String) {
                    return SimpleBranchInstr.createErrorMessage((String)encResult, this.instruction);
                }
                int size = (Integer)encResult;
                instr = new Instruction();
                instr.setNearBranch64(this.ip + (long)this.nearInstructionSize);
                switch (encoder.getBitness()) {
                    case 16: {
                        instr.setCode(699);
                        codeNear = 694;
                        instr.setOp0Kind(1);
                        break;
                    }
                    case 32: {
                        instr.setCode(700);
                        codeNear = 695;
                        instr.setOp0Kind(2);
                        break;
                    }
                    case 64: {
                        instr.setCode(701);
                        codeNear = 696;
                        instr.setOp0Kind(3);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
                encResult = encoder.tryEncode(instr, this.ip + (long)size);
                if (encResult instanceof String) {
                    return SimpleBranchInstr.createErrorMessage((String)encResult, this.instruction);
                }
                size += ((Integer)encResult).intValue();
                instr.setCode(codeNear);
                instr.setNearBranch64(this.targetInstr.getAddress());
                encResult = encoder.tryEncode(instr, this.ip + (long)size);
                if (encResult instanceof String) {
                    return SimpleBranchInstr.createErrorMessage((String)encResult, this.instruction);
                }
                return null;
            }
            case 3: {
                assert (encoder.getBitness() == 64) : encoder.getBitness();
                assert (this.pointerData != null);
                result.isOriginalInstruction = false;
                result.constantOffsets = new ConstantOffsets();
                this.pointerData.data = this.targetInstr.getAddress();
                Instruction instr = this.instruction.copy();
                instr.setCode(this.nativeCode & 0xFFFF);
                instr.setNearBranch64(this.ip + (long)this.nativeInstructionSize + 2L);
                Object encResult = encoder.tryEncode(instr, this.ip);
                if (encResult instanceof String) {
                    return SimpleBranchInstr.createErrorMessage((String)encResult, this.instruction);
                }
                int size = (Integer)encResult;
                instr = new Instruction();
                instr.setNearBranch64(this.ip + (long)this.longInstructionSize);
                switch (encoder.getBitness()) {
                    case 16: {
                        instr.setCode(699);
                        instr.setOp0Kind(1);
                        break;
                    }
                    case 32: {
                        instr.setCode(700);
                        instr.setOp0Kind(2);
                        break;
                    }
                    case 64: {
                        instr.setCode(701);
                        instr.setOp0Kind(3);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
                encResult = encoder.tryEncode(instr, this.ip + (long)size);
                if (encResult instanceof String) {
                    return SimpleBranchInstr.createErrorMessage((String)encResult, this.instruction);
                }
                if ((encResult = this.encodeBranchToPointerData(encoder, false, this.ip + (long)(size += ((Integer)encResult).intValue()), this.pointerData, this.size - size)) instanceof String) {
                    return SimpleBranchInstr.createErrorMessage((String)encResult, this.instruction);
                }
                return null;
            }
        }
        throw new UnsupportedOperationException();
    }

    private static final class InstrKind {
        static final byte UNCHANGED = 0;
        static final byte SHORT = 1;
        static final byte NEAR = 2;
        static final byte LONG = 3;
        static final byte UNINITIALIZED = 4;

        private InstrKind() {
        }
    }
}

