/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.enc;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.enc.Encoder;
import com.github.icedland.iced.x86.enc.Op;

final class OprDI
extends Op {
    OprDI() {
    }

    static int getRegSize(int opKind) {
        if (opKind == 20) {
            return 8;
        }
        if (opKind == 19) {
            return 4;
        }
        if (opKind == 18) {
            return 2;
        }
        return 0;
    }

    @Override
    void encode(Encoder encoder, Instruction instruction, int operand) {
        int regSize = OprDI.getRegSize(instruction.getOpKind(operand));
        if (regSize == 0) {
            encoder.setErrorMessage(String.format("Operand %d: expected OpKind = MEMORY_SEG_DI, MEMORY_SEG_EDI or MEMORY_SEG_RDI", operand));
            return;
        }
        encoder.setAddrSize(regSize);
    }
}

