/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.enc;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.enc.Encoder;
import com.github.icedland.iced.x86.enc.Op;

public abstract class OpCodeHandler {
    final int opCode;
    final boolean is2ByteOpCode;
    final int groupIndex;
    final int rmGroupIndex;
    final boolean isSpecialInstr;
    final int encFlags3;
    final int opSize;
    final int addrSize;
    final TryConvertToDisp8N tryConvertToDisp8N;
    @Deprecated
    public final Op[] operands;

    OpCodeHandler(int encFlags2, int encFlags3, boolean isSpecialInstr, TryConvertToDisp8N tryConvertToDisp8N, Op[] operands) {
        this.encFlags3 = encFlags3;
        this.opCode = OpCodeHandler.getOpCode(encFlags2);
        this.is2ByteOpCode = (encFlags2 & 0x10000) != 0;
        this.groupIndex = (encFlags2 & Integer.MIN_VALUE) == 0 ? -1 : encFlags2 >>> 27 & 7;
        this.rmGroupIndex = (encFlags3 & 0x2000) == 0 ? -1 : encFlags2 >>> 27 & 7;
        this.isSpecialInstr = isSpecialInstr;
        this.opSize = encFlags3 >>> 3 & 3;
        this.addrSize = encFlags3 >>> 5 & 3;
        this.tryConvertToDisp8N = tryConvertToDisp8N;
        this.operands = operands;
    }

    static int getOpCode(int encFlags2) {
        return encFlags2 >>> 0 & 0xFFFF;
    }

    abstract void encode(Encoder var1, Instruction var2);

    static abstract class TryConvertToDisp8N {
        TryConvertToDisp8N() {
        }

        abstract Integer convert(Encoder var1, OpCodeHandler var2, Instruction var3, int var4);
    }
}

