/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.enc;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.enc.Block;
import com.github.icedland.iced.x86.enc.BlockEncoder;
import com.github.icedland.iced.x86.enc.Encoder;
import com.github.icedland.iced.x86.enc.Instr;
import com.github.icedland.iced.x86.enc.TargetInstr;
import com.github.icedland.iced.x86.enc.TryEncodeResult;

final class IpRelMemOpInstr
extends Instr {
    private Instruction instruction;
    private byte instrKind;
    private final byte eipInstructionSize;
    private final byte ripInstructionSize;
    private TargetInstr targetInstr;

    IpRelMemOpInstr(BlockEncoder blockEncoder, Block block, Instruction instruction) {
        super(block, instruction.getIP());
        assert (instruction.isIPRelativeMemoryOperand());
        this.instruction = instruction;
        this.instrKind = (byte)4;
        Instruction instrCopy = instruction.copy();
        instrCopy.setMemoryBase(70);
        instrCopy.setMemoryDisplacement64(0L);
        this.ripInstructionSize = (byte)blockEncoder.getInstructionSize(instrCopy, instrCopy.ipRelativeMemoryAddress());
        instrCopy.setMemoryBase(69);
        this.eipInstructionSize = (byte)blockEncoder.getInstructionSize(instrCopy, instrCopy.ipRelativeMemoryAddress());
        assert (this.eipInstructionSize >= this.ripInstructionSize);
        this.size = this.eipInstructionSize;
    }

    @Override
    void initialize(BlockEncoder blockEncoder) {
        this.targetInstr = blockEncoder.getTarget(this.instruction.ipRelativeMemoryAddress());
    }

    @Override
    boolean optimize(long gained) {
        return this.tryOptimize(gained);
    }

    private boolean tryOptimize(long gained) {
        if (this.instrKind == 0 || this.instrKind == 1 || this.instrKind == 2) {
            this.done = true;
            return false;
        }
        boolean useRip = this.targetInstr.isInBlock(this.block);
        long targetAddress = this.targetInstr.getAddress();
        if (!useRip) {
            long nextRip = this.ip + (long)this.ripInstructionSize;
            long diff = targetAddress - nextRip;
            diff = IpRelMemOpInstr.correctDiff(this.targetInstr.isInBlock(this.block), diff, gained);
            boolean bl = useRip = Integer.MIN_VALUE <= diff && diff <= Integer.MAX_VALUE;
        }
        if (useRip) {
            this.size = this.ripInstructionSize;
            this.instrKind = 1;
            this.done = true;
            return true;
        }
        if (Long.compareUnsigned(targetAddress, 0xFFFFFFFFL) <= 0) {
            this.size = this.eipInstructionSize;
            this.instrKind = (byte)2;
            this.done = true;
            return true;
        }
        this.instrKind = (byte)3;
        return false;
    }

    @Override
    String tryEncode(Encoder encoder, TryEncodeResult result) {
        switch (this.instrKind) {
            case 0: 
            case 1: 
            case 2: {
                boolean b;
                result.isOriginalInstruction = true;
                Instruction instruction = this.instruction.copy();
                if (this.instrKind == 1) {
                    instruction.setMemoryBase(70);
                } else if (this.instrKind == 2) {
                    instruction.setMemoryBase(69);
                } else assert (this.instrKind == 0) : this.instrKind;
                long targetAddress = this.targetInstr.getAddress();
                instruction.setMemoryDisplacement64(targetAddress);
                Object encResult = encoder.tryEncode(instruction, this.ip);
                boolean bl = b = instruction.ipRelativeMemoryAddress() == (instruction.getMemoryBase() == 69 ? targetAddress & 0xFFFFFFFFL : targetAddress);
                assert (b);
                if (!b) {
                    encResult = "Invalid IP relative address";
                }
                if (encResult instanceof String) {
                    return IpRelMemOpInstr.createErrorMessage((String)encResult, instruction);
                }
                result.constantOffsets = encoder.getConstantOffsets();
                return null;
            }
            case 3: {
                return "IP relative memory operand is too far away and isn't currently supported. Try to allocate memory close to the original instruction (+/-2GB).";
            }
        }
        throw new UnsupportedOperationException();
    }

    private static final class InstrKind {
        static final byte UNCHANGED = 0;
        static final byte RIP = 1;
        static final byte EIP = 2;
        static final byte LONG = 3;
        static final byte UNINITIALIZED = 4;

        private InstrKind() {
        }
    }
}

