/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.dec;

import com.github.icedland.iced.x86.dec.HandlerInfo;
import com.github.icedland.iced.x86.dec.OpCodeHandler;
import com.github.icedland.iced.x86.dec.OpCodeHandlerReader;
import com.github.icedland.iced.x86.internal.DataReader;
import java.util.ArrayList;

final class TableDeserializer {
    private final DataReader reader;
    private final OpCodeHandlerReader handlerReader;
    private final ArrayList<HandlerInfo> idToHandler;
    private final OpCodeHandler[] handlerArray;

    TableDeserializer(OpCodeHandlerReader handlerReader, int maxIds, byte[] data) {
        this.handlerReader = handlerReader;
        this.reader = new DataReader(data);
        this.idToHandler = new ArrayList(maxIds);
        this.handlerArray = new OpCodeHandler[1];
    }

    void deserialize() {
        block4: while (this.reader.canRead()) {
            switch (this.reader.readByte()) {
                case 0: {
                    this.idToHandler.add(new HandlerInfo(this.readHandler()));
                    continue block4;
                }
                case 1: {
                    this.idToHandler.add(new HandlerInfo(this.readHandlers(this.reader.readCompressedUInt32())));
                    continue block4;
                }
            }
            throw new UnsupportedOperationException();
        }
        if (this.reader.canRead()) {
            throw new UnsupportedOperationException();
        }
    }

    int readLegacyOpCodeHandlerKind() {
        return this.reader.readByte();
    }

    int readVexOpCodeHandlerKind() {
        return this.reader.readByte();
    }

    int readEvexOpCodeHandlerKind() {
        return this.reader.readByte();
    }

    int readMvexOpCodeHandlerKind() {
        return this.reader.readByte();
    }

    int readCode() {
        return this.reader.readCompressedUInt32();
    }

    int readRegister() {
        return this.reader.readByte();
    }

    int readDecoderOptions() {
        return this.reader.readCompressedUInt32();
    }

    int readHandlerFlags() {
        return this.reader.readCompressedUInt32();
    }

    int readLegacyHandlerFlags() {
        return this.reader.readCompressedUInt32();
    }

    int readTupleType() {
        return this.reader.readByte();
    }

    boolean readBoolean() {
        return this.reader.readByte() != 0;
    }

    int readInt32() {
        return this.reader.readCompressedUInt32();
    }

    OpCodeHandler readHandler() {
        OpCodeHandler handler = this.readHandlerOrNull();
        if (handler == null) {
            throw new UnsupportedOperationException();
        }
        return handler;
    }

    OpCodeHandler readHandlerOrNull() {
        int count = this.handlerReader.readHandlers(this, this.handlerArray, 0);
        if (count != 1) {
            throw new UnsupportedOperationException();
        }
        return this.handlerArray[0];
    }

    OpCodeHandler[] readHandlers(int count) {
        int num;
        OpCodeHandler[] handlers = new OpCodeHandler[count];
        for (int i = 0; i < handlers.length; i += num) {
            num = this.handlerReader.readHandlers(this, handlers, i);
            if (num > 0 && Integer.compareUnsigned(i + num, handlers.length) <= 0) continue;
            throw new UnsupportedOperationException();
        }
        return handlers;
    }

    OpCodeHandler readHandlerReference() {
        int index = this.reader.readByte();
        OpCodeHandler handler = this.idToHandler.get((int)index).handler;
        if (handler == null) {
            throw new UnsupportedOperationException();
        }
        return handler;
    }

    OpCodeHandler[] readArrayReference(int kind) {
        if (this.reader.readByte() != kind) {
            throw new UnsupportedOperationException();
        }
        return this.getTable(this.reader.readByte());
    }

    OpCodeHandler[] getTable(int index) {
        OpCodeHandler[] handlers = this.idToHandler.get((int)index).handlers;
        if (handlers == null) {
            throw new UnsupportedOperationException();
        }
        return handlers;
    }
}

