/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.dec;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.dec.Decoder;
import com.github.icedland.iced.x86.dec.OpCodeHandler;

final class OpCodeHandler_PushIb2
extends OpCodeHandler {
    private final int code16;
    private final int code32;
    private final int code64;

    OpCodeHandler_PushIb2(int code16, int code32, int code64) {
        this.code16 = code16;
        this.code32 = code32;
        this.code64 = code64;
    }

    @Override
    void decode(Decoder decoder, Instruction instruction) {
        if (decoder.is64bMode) {
            if (decoder.state_operandSize != 0) {
                instruction.setCode(this.code64);
                instruction.setOp0Kind(13);
                instruction.setImmediate8((byte)decoder.readByte());
            } else {
                instruction.setCode(this.code16);
                instruction.setOp0Kind(11);
                instruction.setImmediate8((byte)decoder.readByte());
            }
        } else if (decoder.state_operandSize == 1) {
            instruction.setCode(this.code32);
            instruction.setOp0Kind(12);
            instruction.setImmediate8((byte)decoder.readByte());
        } else {
            instruction.setCode(this.code16);
            instruction.setOp0Kind(11);
            instruction.setImmediate8((byte)decoder.readByte());
        }
    }
}

