/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.dec;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.dec.Decoder;
import com.github.icedland.iced.x86.dec.OpCodeHandler;

final class OpCodeHandler_PrefixREX
extends OpCodeHandler {
    private final OpCodeHandler handler;
    private final int rex;

    OpCodeHandler_PrefixREX(OpCodeHandler handler, int rex) {
        if (handler == null) {
            throw new NullPointerException();
        }
        assert (rex <= 15) : rex;
        this.handler = handler;
        this.rex = rex;
    }

    @Override
    void decode(Decoder decoder, Instruction instruction) {
        if (decoder.is64bMode) {
            if ((this.rex & 8) != 0) {
                decoder.state_operandSize = (byte)2;
                decoder.state_zs_flags |= 0x88;
            } else {
                decoder.state_zs_flags |= 8;
                decoder.state_zs_flags &= 0xFFFFFF7F;
                decoder.state_operandSize = (decoder.state_zs_flags & 0x8000) == 0 ? (byte)1 : 0;
            }
            decoder.state_zs_extraRegisterBase = this.rex << 1 & 8;
            decoder.state_zs_extraIndexRegisterBase = this.rex << 2 & 8;
            decoder.state_zs_extraBaseRegisterBase = this.rex << 3 & 8;
            decoder.callOpCodeHandlerXXTable(instruction);
        } else {
            this.handler.decode(decoder, instruction);
        }
    }
}

