/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.dec;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.dec.Decoder;
import com.github.icedland.iced.x86.dec.OpCodeHandler;
import com.github.icedland.iced.x86.dec.OpCodeHandlerModRM;

final class OpCodeHandler_MandatoryPrefix3
extends OpCodeHandlerModRM {
    private final Info[] handlers_reg;
    private final Info[] handlers_mem;

    OpCodeHandler_MandatoryPrefix3(OpCodeHandler handler_reg, OpCodeHandler handler_mem, OpCodeHandler handler66_reg, OpCodeHandler handler66_mem, OpCodeHandler handlerF3_reg, OpCodeHandler handlerF3_mem, OpCodeHandler handlerF2_reg, OpCodeHandler handlerF2_mem, int flags) {
        if (handler_reg == null) {
            throw new NullPointerException();
        }
        if (handler66_reg == null) {
            throw new NullPointerException();
        }
        if (handlerF3_reg == null) {
            throw new NullPointerException();
        }
        if (handlerF2_reg == null) {
            throw new NullPointerException();
        }
        if (handler_mem == null) {
            throw new NullPointerException();
        }
        if (handler66_mem == null) {
            throw new NullPointerException();
        }
        if (handlerF3_mem == null) {
            throw new NullPointerException();
        }
        if (handlerF2_mem == null) {
            throw new NullPointerException();
        }
        this.handlers_reg = new Info[]{new Info(handler_reg, (flags & 1) == 0), new Info(handler66_reg, (flags & 4) == 0), new Info(handlerF3_reg, (flags & 0x10) == 0), new Info(handlerF2_reg, (flags & 0x40) == 0)};
        this.handlers_mem = new Info[]{new Info(handler_mem, (flags & 2) == 0), new Info(handler66_mem, (flags & 8) == 0), new Info(handlerF3_mem, (flags & 0x20) == 0), new Info(handlerF2_mem, (flags & 0x80) == 0)};
        assert (handler_reg.hasModRM == this.hasModRM);
        assert (handler_mem.hasModRM == this.hasModRM);
        assert (handler66_reg.hasModRM == this.hasModRM);
        assert (handler66_mem.hasModRM == this.hasModRM);
        assert (handlerF3_reg.hasModRM == this.hasModRM);
        assert (handlerF3_mem.hasModRM == this.hasModRM);
        assert (handlerF2_reg.hasModRM == this.hasModRM);
        assert (handlerF2_mem.hasModRM == this.hasModRM);
    }

    @Override
    void decode(Decoder decoder, Instruction instruction) {
        Info[] handlers = decoder.state_mod == 3 ? this.handlers_reg : this.handlers_mem;
        Info info = handlers[decoder.state_zs_mandatoryPrefix];
        if (info.mandatoryPrefix) {
            decoder.clearMandatoryPrefix(instruction);
        }
        info.handler.decode(decoder, instruction);
    }

    private static final class Info {
        final OpCodeHandler handler;
        final boolean mandatoryPrefix;

        Info(OpCodeHandler handler, boolean mandatoryPrefix) {
            this.handler = handler;
            this.mandatoryPrefix = mandatoryPrefix;
        }
    }
}

