/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.dec;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.dec.Decoder;
import com.github.icedland.iced.x86.dec.OpCodeHandlerModRM;

final class OpCodeHandler_M_REXW
extends OpCodeHandlerModRM {
    private final int code32;
    private final int code64;
    private final int flags32;
    private final int flags64;

    OpCodeHandler_M_REXW(int code32, int code64) {
        this.code32 = code32;
        this.code64 = code64;
        this.flags32 = 0;
        this.flags64 = 0;
    }

    OpCodeHandler_M_REXW(int code32, int code64, int flags32, int flags64) {
        this.code32 = code32;
        this.code64 = code64;
        this.flags32 = flags32;
        this.flags64 = flags64;
    }

    @Override
    void decode(Decoder decoder, Instruction instruction) {
        if ((decoder.state_zs_flags & 0x80) != 0) {
            instruction.setCode(this.code64);
        } else {
            instruction.setCode(this.code32);
        }
        if (decoder.state_mod == 3) {
            decoder.setInvalidInstruction();
        } else {
            int flags;
            instruction.setOp0Kind(24);
            int n = flags = (decoder.state_zs_flags & 0x80) != 0 ? this.flags64 : this.flags32;
            if ((flags & 3) != 0) {
                decoder.setXacquireXrelease(instruction);
            }
            decoder.state_zs_flags |= (flags & 8) << 10;
            decoder.readOpMem(instruction);
        }
    }
}

