/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.dec;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.dec.Decoder;
import com.github.icedland.iced.x86.dec.OpCodeHandlerModRM;
import com.github.icedland.iced.x86.internal.MvexInfo;

final class OpCodeHandler_MVEX_M
extends OpCodeHandlerModRM {
    private final int code;

    OpCodeHandler_MVEX_M(int code) {
        assert (MvexInfo.getIgnoresOpMaskRegister(code));
        assert (!MvexInfo.canUseEvictionHint(code));
        assert (MvexInfo.getIgnoresEvictionHint(code));
        this.code = code;
    }

    @Override
    void decode(Decoder decoder, Instruction instruction) {
        if ((decoder.state_vvvv_invalidCheck & decoder.invalidCheckMask) != 0) {
            decoder.setInvalidInstruction();
        }
        instruction.setOpMask(0);
        instruction.setCode(this.code);
        int sss = decoder.getSss();
        if (decoder.state_mod == 3) {
            decoder.setInvalidInstruction();
        } else {
            instruction.setOp0Kind(24);
            if ((MvexInfo.getInvalidConvFns(this.code) & 1 << sss & decoder.invalidCheckMask) != 0) {
                decoder.setInvalidInstruction();
            }
            instruction.setMvexRegMemConv(9 + sss);
            decoder.readOpMem(instruction, MvexInfo.getTupleType(this.code, sss));
        }
    }
}

