/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.dec;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.dec.Decoder;
import com.github.icedland.iced.x86.dec.OpCodeHandlerModRM;

final class OpCodeHandler_BM_B
extends OpCodeHandlerModRM {
    private final int code32;
    private final int code64;

    OpCodeHandler_BM_B(int code32, int code64) {
        this.code32 = code32;
        this.code64 = code64;
    }

    @Override
    void decode(Decoder decoder, Instruction instruction) {
        if (decoder.state_reg > 3 || (decoder.state_zs_extraRegisterBase & decoder.invalidCheckMask) != 0) {
            decoder.setInvalidInstruction();
        }
        if (decoder.is64bMode) {
            instruction.setCode(this.code64);
        } else {
            instruction.setCode(this.code32);
        }
        instruction.setOp1Register(decoder.state_reg + 181);
        if (decoder.state_mod == 3) {
            instruction.setOp0Register(decoder.state_rm + 181);
            if (decoder.state_rm > 3 || (decoder.state_zs_extraBaseRegisterBase & decoder.invalidCheckMask) != 0) {
                decoder.setInvalidInstruction();
            }
        } else {
            instruction.setOp0Kind(24);
            decoder.readOpMem_MPX(instruction);
        }
    }
}

