/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.dec;

import com.github.icedland.iced.x86.dec.OpCodeHandler;
import com.github.icedland.iced.x86.dec.OpCodeHandlerReader;
import com.github.icedland.iced.x86.dec.OpCodeHandler_EH;
import com.github.icedland.iced.x86.dec.OpCodeHandler_Group;
import com.github.icedland.iced.x86.dec.OpCodeHandler_Invalid;
import com.github.icedland.iced.x86.dec.OpCodeHandler_MVEX_HWIb;
import com.github.icedland.iced.x86.dec.OpCodeHandler_MVEX_KHW;
import com.github.icedland.iced.x86.dec.OpCodeHandler_MVEX_KHWIb;
import com.github.icedland.iced.x86.dec.OpCodeHandler_MVEX_M;
import com.github.icedland.iced.x86.dec.OpCodeHandler_MVEX_MV;
import com.github.icedland.iced.x86.dec.OpCodeHandler_MVEX_VHW;
import com.github.icedland.iced.x86.dec.OpCodeHandler_MVEX_VHWIb;
import com.github.icedland.iced.x86.dec.OpCodeHandler_MVEX_VKW;
import com.github.icedland.iced.x86.dec.OpCodeHandler_MVEX_VSIB;
import com.github.icedland.iced.x86.dec.OpCodeHandler_MVEX_VSIB_V;
import com.github.icedland.iced.x86.dec.OpCodeHandler_MVEX_VW;
import com.github.icedland.iced.x86.dec.OpCodeHandler_MVEX_VWIb;
import com.github.icedland.iced.x86.dec.OpCodeHandler_MVEX_V_VSIB;
import com.github.icedland.iced.x86.dec.OpCodeHandler_MandatoryPrefix2;
import com.github.icedland.iced.x86.dec.OpCodeHandler_RM;
import com.github.icedland.iced.x86.dec.OpCodeHandler_W;
import com.github.icedland.iced.x86.dec.TableDeserializer;

final class MvexOpCodeHandlerReader
extends OpCodeHandlerReader {
    MvexOpCodeHandlerReader() {
    }

    @Override
    int readHandlers(TableDeserializer deserializer, OpCodeHandler[] result, int resultIndex) {
        OpCodeHandler elem;
        switch (deserializer.readMvexOpCodeHandlerKind()) {
            case 0: {
                elem = OpCodeHandler_Invalid.Instance;
                break;
            }
            case 1: {
                result[resultIndex] = OpCodeHandler_Invalid.Instance;
                result[resultIndex + 1] = OpCodeHandler_Invalid.Instance;
                return 2;
            }
            case 2: {
                int count = deserializer.readInt32();
                OpCodeHandler handler = deserializer.readHandler();
                for (int i = 0; i < count; ++i) {
                    result[resultIndex + i] = handler;
                }
                return count;
            }
            case 3: {
                elem = deserializer.readHandlerReference();
                break;
            }
            case 4: {
                throw new UnsupportedOperationException();
            }
            case 5: {
                elem = new OpCodeHandler_RM(deserializer.readHandler(), deserializer.readHandler());
                break;
            }
            case 6: {
                elem = new OpCodeHandler_Group(deserializer.readArrayReference(4));
                break;
            }
            case 7: {
                elem = new OpCodeHandler_W(deserializer.readHandler(), deserializer.readHandler());
                break;
            }
            case 8: {
                elem = new OpCodeHandler_MandatoryPrefix2(deserializer.readHandler(), deserializer.readHandler(), deserializer.readHandler(), deserializer.readHandler());
                break;
            }
            case 9: {
                elem = new OpCodeHandler_EH(deserializer.readHandler(), deserializer.readHandler());
                break;
            }
            case 10: {
                elem = new OpCodeHandler_MVEX_M(deserializer.readCode());
                break;
            }
            case 11: {
                elem = new OpCodeHandler_MVEX_MV(deserializer.readCode());
                break;
            }
            case 12: {
                elem = new OpCodeHandler_MVEX_VW(deserializer.readCode());
                break;
            }
            case 13: {
                elem = new OpCodeHandler_MVEX_HWIb(deserializer.readCode());
                break;
            }
            case 14: {
                elem = new OpCodeHandler_MVEX_VWIb(deserializer.readCode());
                break;
            }
            case 15: {
                elem = new OpCodeHandler_MVEX_VHW(deserializer.readCode());
                break;
            }
            case 16: {
                elem = new OpCodeHandler_MVEX_VHWIb(deserializer.readCode());
                break;
            }
            case 17: {
                elem = new OpCodeHandler_MVEX_VKW(deserializer.readCode());
                break;
            }
            case 18: {
                elem = new OpCodeHandler_MVEX_KHW(deserializer.readCode());
                break;
            }
            case 19: {
                elem = new OpCodeHandler_MVEX_KHWIb(deserializer.readCode());
                break;
            }
            case 20: {
                elem = new OpCodeHandler_MVEX_VSIB(deserializer.readCode());
                break;
            }
            case 21: {
                elem = new OpCodeHandler_MVEX_VSIB_V(deserializer.readCode());
                break;
            }
            case 22: {
                elem = new OpCodeHandler_MVEX_V_VSIB(deserializer.readCode());
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        result[resultIndex] = elem;
        return 1;
    }
}

