/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.dec;

import com.github.icedland.iced.x86.dec.CodeReader;

public final class ByteArrayCodeReader
extends CodeReader {
    private final byte[] data;
    private int currentPosition;
    private final int startPosition;
    private final int endPosition;

    public int getPosition() {
        return this.currentPosition - this.startPosition;
    }

    public void setPosition(int value) {
        if (Integer.compareUnsigned(value, this.size()) > 0) {
            throw new IllegalArgumentException("value");
        }
        this.currentPosition = this.startPosition + value;
    }

    public int size() {
        return this.endPosition - this.startPosition;
    }

    public boolean canReadByte() {
        return this.currentPosition < this.endPosition;
    }

    public ByteArrayCodeReader(byte[] data) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        this.data = data;
        this.currentPosition = 0;
        this.startPosition = 0;
        this.endPosition = data.length;
    }

    public ByteArrayCodeReader(byte[] data, int index, int count) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        this.data = data;
        if (index < 0) {
            throw new IllegalArgumentException("index");
        }
        if (count < 0) {
            throw new IllegalArgumentException("count");
        }
        if (Integer.compareUnsigned(index + count, data.length) > 0) {
            throw new IllegalArgumentException("count");
        }
        this.currentPosition = index;
        this.startPosition = index;
        this.endPosition = index + count;
    }

    @Override
    public int readByte() {
        if (this.currentPosition >= this.endPosition) {
            return -1;
        }
        return this.data[this.currentPosition++] & 0xFF;
    }
}

