/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.asm;

import com.github.icedland.iced.x86.ICRegister;
import com.github.icedland.iced.x86.Register;
import com.github.icedland.iced.x86.asm.AsmMemoryOperand;
import com.github.icedland.iced.x86.asm.AsmRegisterXMM;
import com.github.icedland.iced.x86.asm.AsmRegisterYMM;
import com.github.icedland.iced.x86.asm.AsmRegisterZMM;

public final class AsmRegister64 {
    private final ICRegister register;
    final int flags;

    public AsmRegister64(ICRegister register) {
        if (!Register.isGPR64(register.get())) {
            throw new IllegalArgumentException("Invalid register value. Must be a GPR64 register");
        }
        this.register = register;
        this.flags = 0;
    }

    public ICRegister get() {
        return this.register;
    }

    public int getRegister() {
        return this.register.get();
    }

    public AsmRegister64(ICRegister register, int flags) {
        if (!Register.isGPR64(register.get())) {
            throw new IllegalArgumentException("Invalid register value. Must be a GPR64 register");
        }
        this.register = register;
        this.flags = flags;
    }

    public AsmRegister64 k1() {
        return new AsmRegister64(this.register, this.flags & 0xFFFFFE3F | 0x40);
    }

    public AsmRegister64 k2() {
        return new AsmRegister64(this.register, this.flags & 0xFFFFFE3F | 0x80);
    }

    public AsmRegister64 k3() {
        return new AsmRegister64(this.register, this.flags & 0xFFFFFE3F | 0xC0);
    }

    public AsmRegister64 k4() {
        return new AsmRegister64(this.register, this.flags & 0xFFFFFE3F | 0x100);
    }

    public AsmRegister64 k5() {
        return new AsmRegister64(this.register, this.flags & 0xFFFFFE3F | 0x140);
    }

    public AsmRegister64 k6() {
        return new AsmRegister64(this.register, this.flags & 0xFFFFFE3F | 0x180);
    }

    public AsmRegister64 k7() {
        return new AsmRegister64(this.register, this.flags & 0xFFFFFE3F | 0x1C0);
    }

    public AsmRegister64 z() {
        return new AsmRegister64(this.register, this.flags | 2);
    }

    public AsmRegister64 sae() {
        return new AsmRegister64(this.register, this.flags | 4);
    }

    public AsmRegister64 rn_sae() {
        return new AsmRegister64(this.register, this.flags & 0xFFFFFFC7 | 8);
    }

    public AsmRegister64 rd_sae() {
        return new AsmRegister64(this.register, this.flags & 0xFFFFFFC7 | 0x10);
    }

    public AsmRegister64 ru_sae() {
        return new AsmRegister64(this.register, this.flags & 0xFFFFFFC7 | 0x18);
    }

    public AsmRegister64 rz_sae() {
        return new AsmRegister64(this.register, this.flags & 0xFFFFFFC7 | 0x20);
    }

    public AsmMemoryOperand add(AsmRegister64 index) {
        return new AsmMemoryOperand(0, ICRegister.NONE, this.get(), index.get(), 1, 0L, 0);
    }

    public AsmMemoryOperand add(AsmRegisterXMM index) {
        return new AsmMemoryOperand(0, ICRegister.NONE, this.get(), index.get(), 1, 0L, 0);
    }

    public AsmMemoryOperand add(AsmRegisterYMM index) {
        return new AsmMemoryOperand(0, ICRegister.NONE, this.get(), index.get(), 1, 0L, 0);
    }

    public AsmMemoryOperand add(AsmRegisterZMM index) {
        return new AsmMemoryOperand(0, ICRegister.NONE, this.get(), index.get(), 1, 0L, 0);
    }

    public AsmMemoryOperand add(long displacement) {
        return new AsmMemoryOperand(0, ICRegister.NONE, this.get(), ICRegister.NONE, 1, displacement, 0);
    }

    public AsmMemoryOperand sub(long displacement) {
        return new AsmMemoryOperand(0, ICRegister.NONE, this.get(), ICRegister.NONE, 1, -displacement, 0);
    }

    public AsmMemoryOperand scale(int scale) {
        return new AsmMemoryOperand(0, ICRegister.NONE, ICRegister.NONE, this.get(), scale, 0L, 0);
    }

    public AsmMemoryOperand add(AsmMemoryOperand mem) {
        return mem.add(this);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AsmRegister64 other = (AsmRegister64)obj;
        return this.register.get() == other.register.get() && this.flags == other.flags;
    }

    public int hashCode() {
        return this.register.get() * 397 ^ this.flags;
    }

    public String toString() {
        return String.format("Register %d, flags: %d", this.getRegister(), this.flags);
    }
}

