/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.asm;

import com.github.icedland.iced.x86.ICRegister;
import com.github.icedland.iced.x86.Register;
import com.github.icedland.iced.x86.asm.AsmMemoryOperand;

public final class AsmRegister16 {
    private final ICRegister register;

    public AsmRegister16(ICRegister register) {
        if (!Register.isGPR16(register.get())) {
            throw new IllegalArgumentException("Invalid register value. Must be a GPR16 register");
        }
        this.register = register;
    }

    public ICRegister get() {
        return this.register;
    }

    public int getRegister() {
        return this.register.get();
    }

    public AsmMemoryOperand add(AsmRegister16 index) {
        return new AsmMemoryOperand(0, ICRegister.NONE, this.get(), index.get(), 1, 0L, 0);
    }

    public AsmMemoryOperand add(long displacement) {
        return new AsmMemoryOperand(0, ICRegister.NONE, this.get(), ICRegister.NONE, 1, displacement, 0);
    }

    public AsmMemoryOperand sub(long displacement) {
        return new AsmMemoryOperand(0, ICRegister.NONE, this.get(), ICRegister.NONE, 1, -displacement, 0);
    }

    public AsmMemoryOperand add(AsmMemoryOperand mem) {
        return mem.add(this);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AsmRegister16 other = (AsmRegister16)obj;
        return this.register.get() == other.register.get();
    }

    public int hashCode() {
        return this.register.get();
    }

    public String toString() {
        return String.format("Register %d", this.getRegister());
    }
}

